/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.util.ArrayList;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IAtsDatabaseConversion;
import org.eclipse.osee.ats.api.util.IAtsOperationCache;
import org.eclipse.osee.ats.api.util.health.HealthCheckResults;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;

public class ConvertToStateAndAssigneeAttributes
implements IAtsDatabaseConversion {
    private final OrcsApi orcsApi;
    private final boolean debug = false;
    private final String TITLE = "Convert Current State Attrs";

    public ConvertToStateAndAssigneeAttributes(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public void run(XResultData rd, boolean reportOnly, AtsApi atsApi) {
        rd.errorf("TODO: This convert should not be used without fix/update", new Object[0]);
    }

    public String getDescription() {
        StringBuffer data = new StringBuffer();
        data.append("Updates ATS workflows to new ats.Current State Name and ats.Assignee(required)\n\n");
        data.append("Necessary for upgrade from 0.26.9\n\n");
        data.append("This will create new attrs as needed.\nCan be run multiple times without corruption.\nShould be run periodically on 0.26.9\n");
        return data.toString();
    }

    public String getName() {
        return "Convert to ats.Current State Name and Assignees";
    }

    private static class TestAssignees {
        private TestAssignees() {
        }

        public boolean check(ArtifactToken artifact, IAtsWorkItem workItem, HealthCheckResults results, AtsApi atsApi, IAtsChangeSet changes, IAtsOperationCache cache) {
            String cfr_ignored_0 = (String)atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentState, (Object)"unknown");
            ArrayList userArtIds = new ArrayList();
            ArrayList<Long> currUserArtIds = new ArrayList<Long>();
            for (String id : atsApi.getAttributeResolver().getAttributesToStringList((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentStateAssignee)) {
                if (Strings.isNumeric((String)id)) {
                    currUserArtIds.add(Long.valueOf(id));
                    continue;
                }
                results.log((ArtifactId)artifact, "TestAssignees", String.format("Error: Invalid Current State Assigne [%s] for %s", id, workItem.toStringWithId()));
            }
            if (Collections.setComplement(currUserArtIds, userArtIds).size() > 0 || Collections.setComplement(userArtIds, currUserArtIds).size() > 0) {
                results.log((ArtifactId)artifact, "TestAssignees", String.format("Info: Updated Current State Assignees attr to [%s] for %s", userArtIds, workItem.toStringWithId()));
                if (changes != null) {
                    changes.setAttributeValues((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentStateAssignee, Collections.castAll(userArtIds));
                }
            }
            return true;
        }
    }

    private class TestCurrentState {
        private TestCurrentState() {
        }

        public boolean check(ArtifactToken artifact, IAtsWorkItem workItem, HealthCheckResults results, AtsApi atsApi, IAtsChangeSet changes, IAtsOperationCache cache) {
            String currentStatename = (String)atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentState, (Object)"unknown");
            currentStatename = currentStatename.replaceFirst(";.*$", "");
            WorkDefinition workDef = workItem.getWorkDefinition();
            if (workDef == null) {
                results.log((ArtifactId)artifact, "TestCurrentStateIsInWorkDef", String.format("Error: Work Definition null for %s", workItem.toStringWithId()));
            } else if (workDef.getStateByName(currentStatename) == null) {
                results.log((ArtifactId)artifact, "TestCurrentStateIsInWorkDef", String.format("Error: Current State [%s] not valid for Work Definition [%s] for " + artifact.toStringWithId(), currentStatename, workDef.getName()));
            }
            String currStateNameAttr = (String)atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentStateName, (Object)"");
            if (!currentStatename.equals(currStateNameAttr)) {
                results.log((ArtifactId)artifact, "TestCurrentStateIsInWorkDef", String.format("Info: Updated Current State Name attr to [%s] for %s", currentStatename, workItem.toStringWithId()));
                if (changes != null) {
                    changes.setSoleAttributeValue(workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentStateName, currentStatename);
                }
            }
            return true;
        }
    }
}

