/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.resource.management.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Zip;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.framework.resource.management.internal.CompressedResourceBridge;

public class Resources {
    private static String removeName(String path) {
        int index = path.lastIndexOf("/");
        if (index != -1) {
            path = path.substring(0, index + 1);
        }
        return path;
    }

    public static IResource compressResource(IResource resource) {
        byte[] buffer;
        block5: {
            InputStream inputStream = null;
            buffer = new byte[]{};
            try {
                try {
                    inputStream = resource.getContent();
                    buffer = Zip.compressStream((InputStream)inputStream, (String)resource.getName());
                }
                catch (IOException ex) {
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                    Lib.close((AutoCloseable)inputStream);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Lib.close((AutoCloseable)inputStream);
                throw throwable;
            }
            Lib.close((AutoCloseable)inputStream);
        }
        return Resources.createResourceFromBytes(buffer, resource.getLocation() + ".zip", true);
    }

    public static IResource decompressResource(IResource resource) {
        String fileName;
        ByteArrayOutputStream outputStream;
        String path;
        block5: {
            path = resource.getLocation().toASCIIString();
            outputStream = new ByteArrayOutputStream();
            fileName = null;
            InputStream inputStream = null;
            try {
                try {
                    inputStream = resource.getContent();
                    fileName = Zip.decompressStream((InputStream)inputStream, (OutputStream)outputStream);
                    fileName = URLEncoder.encode(fileName, "UTF-8");
                }
                catch (IOException ex) {
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                    Lib.close((AutoCloseable)inputStream);
                    Lib.close((AutoCloseable)outputStream);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Lib.close((AutoCloseable)inputStream);
                Lib.close((AutoCloseable)outputStream);
                throw throwable;
            }
            Lib.close((AutoCloseable)inputStream);
            Lib.close((AutoCloseable)outputStream);
        }
        path = fileName != null && fileName.length() > 0 ? String.valueOf(Resources.removeName(path)) + fileName : Lib.removeExtension((String)path);
        return Resources.createResourceFromBytes(outputStream.toByteArray(), path, false);
    }

    public static IResource createResourceFromBytes(byte[] bytes, String path, boolean isCompressed) {
        try {
            return new CompressedResourceBridge(bytes, new URI(path), isCompressed);
        }
        catch (URISyntaxException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }
}

