/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.coverage.internal;

import java.util.Collection;
import org.eclipse.osee.coverage.PartitionChartDataApi;
import org.eclipse.osee.coverage.PartitionChartDataEndpoint;
import org.eclipse.osee.coverage.internal.PartitionChartDataToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class PartitionChartDataEndpointImpl
implements PartitionChartDataEndpoint {
    private final PartitionChartDataApi partitionChartDataApi;
    private final BranchId branch;

    public PartitionChartDataEndpointImpl(BranchId branch, PartitionChartDataApi partitionChartDataApi) {
        this.partitionChartDataApi = partitionChartDataApi;
        this.branch = branch;
    }

    @Override
    public Collection<PartitionChartDataToken> getAllPartitionChartDatas(String filter, ArtifactId viewId, long pageNum, long pageSize, AttributeTypeToken orderByAttributeType, boolean activeOnly) {
        ArtifactId artifactId = viewId = viewId.isValid() ? viewId : ArtifactId.SENTINEL;
        if (Strings.isValid((String)filter)) {
            return this.partitionChartDataApi.getAllByFilter(this.branch, viewId, filter, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
        }
        return this.partitionChartDataApi.getAll(this.branch, viewId, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
    }

    @Override
    public PartitionChartDataToken getPartitionChartData(ArtifactId partitionChartDataId) {
        return this.partitionChartDataApi.get(this.branch, partitionChartDataId);
    }

    @Override
    public int getCount(String filter, ArtifactId viewId) {
        return this.partitionChartDataApi.getCountWithFilter(this.branch, viewId, filter);
    }
}

