/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.coverage.internal;

import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.osee.coverage.CoverageApi;
import org.eclipse.osee.coverage.CoverageEndpoint;
import org.eclipse.osee.coverage.CoverageProgramEndpoint;
import org.eclipse.osee.coverage.PartitionChartDataEndpoint;
import org.eclipse.osee.coverage.PartitionDefEndpoint;
import org.eclipse.osee.coverage.PartitionResultEndpoint;
import org.eclipse.osee.coverage.internal.CoverageImportEndpointImpl;
import org.eclipse.osee.coverage.internal.CoverageItemEndpointImpl;
import org.eclipse.osee.coverage.internal.CoverageProgramEndpointImpl;
import org.eclipse.osee.coverage.internal.PartitionChartDataEndpointImpl;
import org.eclipse.osee.coverage.internal.PartitionDefEndpointImpl;
import org.eclipse.osee.coverage.internal.PartitionResultEndpointImpl;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.annotation.Swagger;

@Path(value="branch")
@Swagger
public class CoverageEndpointImpl
implements CoverageEndpoint {
    private final CoverageApi coverageApi;

    public CoverageEndpointImpl(CoverageApi coverageApi) {
        this.coverageApi = coverageApi;
    }

    @Override
    @Path(value="{branch}/program")
    @Produces(value={"application/json"})
    public CoverageProgramEndpoint getCoverageProgram(@PathParam(value="branch") BranchId branch) {
        return new CoverageProgramEndpointImpl(branch, this.coverageApi.getCoverageProgramApi());
    }

    @Override
    @Path(value="{branch}/def")
    @Produces(value={"application/json"})
    public PartitionDefEndpoint getPartitionDef(@PathParam(value="branch") BranchId branch) {
        return new PartitionDefEndpointImpl(branch, this.coverageApi.getPartitionDefApi());
    }

    @Override
    @Path(value="{branch}/result")
    @Produces(value={"application/json"})
    public PartitionResultEndpoint getPartitionResult(@PathParam(value="branch") BranchId branch) {
        return new PartitionResultEndpointImpl(branch, this.coverageApi.getPartitionResultApi());
    }

    @Override
    @Path(value="{branch}/data")
    @Produces(value={"application/json"})
    public PartitionChartDataEndpoint getPartitionChartData(@PathParam(value="branch") BranchId branch) {
        return new PartitionChartDataEndpointImpl(branch, this.coverageApi.getPartitionChartDataApi());
    }

    @Override
    @Path(value="{branch}/item")
    @Produces(value={"application/json"})
    public CoverageItemEndpointImpl getCoverageItem(@PathParam(value="branch") BranchId branch) {
        return new CoverageItemEndpointImpl(branch, this.coverageApi.getCoverageItemApi());
    }

    @Override
    @Path(value="{branch}/import")
    @Produces(value={"application/json"})
    public CoverageImportEndpointImpl getCoverageImport(@PathParam(value="branch") BranchId branch) {
        return new CoverageImportEndpointImpl(branch, this.coverageApi.getCoverageImportApi());
    }
}

