/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.rest.internal;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.osee.account.rest.internal.AccountOps;
import org.eclipse.osee.account.rest.model.AccountActiveData;
import org.eclipse.osee.framework.core.data.ArtifactId;

public class AccountActiveResource {
    private final AccountOps accountOps;
    private final ArtifactId accountId;

    public AccountActiveResource(AccountOps accountOps, ArtifactId accountId) {
        this.accountOps = accountOps;
        this.accountId = accountId;
    }

    @GET
    @RolesAllowed(value={"authenticated"})
    @Produces(value={"application/json", "application/xml"})
    public AccountActiveData isActive() {
        return this.accountOps.isActive(this.accountId);
    }

    @PUT
    @RolesAllowed(value={"authenticated"})
    public Response setActive() {
        boolean modified = this.accountOps.setAccountActive(this.accountId, true);
        Response.ResponseBuilder builder = modified ? Response.ok() : Response.notModified();
        return builder.build();
    }

    @DELETE
    @RolesAllowed(value={"authenticated"})
    public Response setInactive() {
        boolean modified = this.accountOps.setAccountActive(this.accountId, false);
        Response.ResponseBuilder builder = modified ? Response.ok() : Response.notModified();
        return builder.build();
    }
}

