/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.console.admin.internal;

import java.util.Collection;
import java.util.Date;
import org.eclipse.osee.console.admin.ConsoleParameters;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class ConsoleParametersImpl
implements ConsoleParameters {
    private final String commandName;
    private final String rawString;
    private final PropertyStore store;
    private final Collection<String> options;

    public ConsoleParametersImpl(String commandName, String rawString, PropertyStore store, Collection<String> options) {
        this.commandName = commandName;
        this.rawString = rawString;
        this.store = store;
        this.options = options;
    }

    @Override
    public String getRawString() {
        return this.rawString;
    }

    @Override
    public String get(String key) {
        return this.store.get(key);
    }

    @Override
    public String[] getArray(String key) {
        return this.store.getArray(key);
    }

    @Override
    public boolean getBoolean(String key) {
        return this.store.getBoolean(key);
    }

    @Override
    public double getDouble(String key) throws NumberFormatException {
        return this.store.getDouble(key);
    }

    @Override
    public float getFloat(String key) throws NumberFormatException {
        return this.store.getFloat(key);
    }

    @Override
    public int getInt(String key) throws NumberFormatException {
        return this.store.getInt(key);
    }

    @Override
    public long getLong(String key) throws NumberFormatException {
        return this.store.getLong(key);
    }

    @Override
    public Date getDate(String key) throws IllegalArgumentException {
        long value = this.store.getLong(key);
        return new Date(value);
    }

    @Override
    public boolean exists(String key) {
        return Strings.isValid((String)this.store.get(key));
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public Collection<String> getOptions() {
        return this.options;
    }
}

