/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.writers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.internal.writers.reflection.ASTParserUtil;
import org.eclipse.osee.orcs.rest.internal.writers.reflection.GenericMethodInvoker;
import org.eclipse.osee.orcs.rest.internal.writers.reflection.TemplateReflector;
import org.eclipse.osee.orcs.rest.internal.writers.reflection.TemplateVisitor;
import org.eclipse.osee.orcs.rest.model.GenericReport;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;

public final class TemplateParser {
    private final OrcsApi orcsApi;
    private final QueryFactory queryApi;
    private final BranchToken branch;
    private final ArtifactId view;
    private final ArtifactId reportTemplateArt;
    private final XResultData results;

    public TemplateParser(OrcsApi orcsApi, BranchId branch, ArtifactId view, ArtifactId templateArt, XResultData results) {
        this.orcsApi = orcsApi;
        this.queryApi = orcsApi.getQueryFactory();
        this.branch = (BranchToken)((BranchQuery)orcsApi.getQueryFactory().branchQuery().andId(branch)).getResultsAsId().getExactlyOne();
        this.view = view;
        this.reportTemplateArt = templateArt;
        this.results = results;
    }

    public ArtifactReadable getTemplateArtifact() {
        return this.queryApi.fromBranch((BranchId)CoreBranches.COMMON).andId(this.reportTemplateArt).getArtifact();
    }

    public void parseTemplateData(GenericReport report) {
        IProblem[] problems;
        String code = this.getTemplateArtifact().getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.JavaCode);
        ASTParserUtil parser = new ASTParserUtil();
        this.setPathsForParser(parser);
        CompilationUnit parsedCode = parser.parse(code);
        if (!parsedCode.getAST().hasBindingsRecovery()) {
            this.results.log("Bindings not activated in Template Parser");
        }
        IProblem[] iProblemArray = problems = parsedCode.getProblems();
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem = iProblemArray[n2];
            this.results.log("AST Parse Compiler: " + problem.getMessage());
            ++n2;
        }
        TemplateVisitor visitor = new TemplateVisitor();
        parsedCode.accept((ASTVisitor)visitor);
        List<MethodInvocation> methods = visitor.getInvocations();
        List<ImportDeclaration> imports = visitor.getImports();
        TemplateReflector reflector = new TemplateReflector(report, this.results);
        this.setReflectionClasses(reflector, imports);
        ListIterator<MethodInvocation> iterator = methods.listIterator();
        while (iterator.hasNext()) {
            MethodInvocation method = iterator.next();
            String methodName = method.getName().getFullyQualifiedName();
            this.results.logf("MethodName: %s", new Object[]{methodName});
            GenericMethodInvoker<GenericReport> invoker = new GenericMethodInvoker<GenericReport>(report);
            List args = method.arguments();
            ArrayList<Object> arguments = new ArrayList<Object>();
            for (Expression arg : args) {
                Object result = reflector.getArgumentFromASTExpression(arg, iterator);
                this.results.logf("    Arg: %s: type %d", new Object[]{arg.toString(), arg.getNodeType()});
                if (result == null) {
                    this.results.errorf("invalid argument type %s", new Object[]{arg.toString()});
                    return;
                }
                arguments.add(result);
            }
            if (methodName.equals("query")) {
                report = reflector.invokeStack(report);
                continue;
            }
            if (methodName.equals("level")) {
                invoker.set(methodName, arguments);
                reflector.pushMethod(invoker);
                report = reflector.invokeStack(report);
                continue;
            }
            if (invoker.set(methodName, arguments)) {
                reflector.pushMethod(invoker);
                continue;
            }
            this.results.logf("Error setting method %s", new Object[]{methodName});
        }
    }

    private void setReflectionClasses(TemplateReflector reflector, List<ImportDeclaration> imports) {
        reflector.setAllowedReflectionClass(CoreArtifactTypes.class);
        reflector.setAllowedReflectionClass(CoreAttributeTypes.class);
        reflector.setAllowedReflectionClass(CoreRelationTypes.class);
        for (ImportDeclaration imp : imports) {
            String impName = imp.getName().getFullyQualifiedName();
            if (!impName.contains("AttributeType") && !impName.contains("ArtifactType") && !impName.contains("RelationType")) continue;
            try {
                Class<?> clazz = Class.forName(impName);
                reflector.setAllowedReflectionClass(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.results.logf("classloader could not find %s", new Object[]{impName});
            }
        }
    }

    private void setPathsForParser(ASTParserUtil parser) {
        try {
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(new File(Class.forName("org.eclipse.osee.orcs.rest.model.GenericReport").getProtectionDomain().getCodeSource().getLocation().toURI()).getPath());
            paths.add(new File(Class.forName("org.eclipse.osee.orcs.rest.internal.writers.GenericReportBuilder").getProtectionDomain().getCodeSource().getLocation().toURI()).getPath());
            paths.add(new File(Class.forName("org.eclipse.osee.orcs.search.QueryBuilder").getProtectionDomain().getCodeSource().getLocation().toURI()).getPath());
            paths.add(new File(Class.forName("org.eclipse.osee.framework.jdk.core.type.ResultSet").getProtectionDomain().getCodeSource().getLocation().toURI()).getPath());
            paths.add(new File(Class.forName("org.eclipse.osee.framework.core.data.ArtifactId").getProtectionDomain().getCodeSource().getLocation().toURI()).getPath());
            this.results.log("Adding base paths");
            for (String path : paths) {
                parser.addClassPath(path);
                this.results.log(path);
            }
            ArtifactReadable templateArt = this.getTemplateArtifact();
            if (templateArt.getAttributeCount((AttributeTypeToken)CoreAttributeTypes.Annotation) > 0) {
                List attrPaths = this.getTemplateArtifact().getAttributeValues((AttributeTypeToken)CoreAttributeTypes.Annotation);
                this.results.logf("Adding paths from template artifact %d", new Object[]{templateArt.getIdString()});
                for (String path : attrPaths) {
                    if (path.startsWith("relative/")) {
                        String[] relativePath = path.split("/");
                        parser.addClassPath(new File(Class.forName(relativePath[1]).getProtectionDomain().getCodeSource().getLocation().toURI()).getPath());
                    }
                    parser.addClassPath(path);
                    this.results.log(path);
                }
            } else {
                this.results.logf("No Annotation Based Paths set in annotations for template artifact %s", new Object[]{templateArt.getIdString()});
            }
        }
        catch (Exception ex) {
            this.results.errorf("failed to add path for TemplateParser: %s", new Object[]{ex.toString()});
        }
    }
}

