/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.search.artifact.predicate;

import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.internal.search.artifact.PredicateHandler;
import org.eclipse.osee.orcs.rest.internal.search.artifact.predicate.PredicateHandlerUtil;
import org.eclipse.osee.orcs.rest.model.search.artifact.Predicate;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchMethod;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class RelatedRecursiveToPredicateHandler
implements PredicateHandler {
    @Override
    public QueryBuilder handle(OrcsApi orcsApi, QueryBuilder builder, Predicate predicate) {
        if (predicate.getType() != SearchMethod.RELATED_RECURSIVE_TO) {
            throw new OseeArgumentException("This predicate handler only supports [%s]", new Object[]{SearchMethod.RELATED_RECURSIVE_TO});
        }
        List typeParameters = predicate.getTypeParameters();
        List values = predicate.getValues();
        Conditions.checkNotNull((Object)typeParameters, (String)"typeParameters");
        Conditions.checkNotNull((Object)values, (String)"values");
        if (typeParameters.size() != 1 || values.size() != 1) {
            return builder;
        }
        RelationTypeSide relationTypeSide = PredicateHandlerUtil.getRelationTypeSides(typeParameters, orcsApi.tokenService()).iterator().next();
        String value = (String)values.get(0);
        if (GUID.isValid((CharSequence)value)) {
            throw new UnsupportedOperationException();
        }
        ArtifactId artifactIdentifier = ArtifactId.valueOf((String)value);
        return builder.andRelatedRecursive(relationTypeSide, artifactIdentifier);
    }
}

