/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.health.operations;

import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcClient;

public class HealthActiveMq {
    private final JdbcClient jdbcClient;
    private String activeMqUrl = "";
    private Boolean active = false;
    private String errorMsg = "";

    public HealthActiveMq(JdbcClient jdbcClient) {
        this.jdbcClient = jdbcClient;
    }

    public void setActiveMqInfo() {
        String fetchedActiveMQUrl = (String)this.jdbcClient.fetch((Object)"", "Select OSEE_VALUE FROM osee_info where OSEE_KEY = ?", new Object[]{"osee.health.activemq.url"});
        if (Strings.isValid((String)fetchedActiveMQUrl)) {
            this.activeMqUrl = fetchedActiveMQUrl;
            try {
                String urlPageHtml = AHTML.getUrlPageHtml((String)fetchedActiveMQUrl);
                this.active = urlPageHtml.contains("Apache ActiveMQ");
            }
            catch (Exception e) {
                this.errorMsg = e.getMessage();
            }
        } else {
            this.activeMqUrl = "osee.health.activemq.url not set in osee_info";
        }
    }

    public String getActiveMqUrl() {
        return this.activeMqUrl;
    }

    public Boolean getActive() {
        return this.active;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }
}

