/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionResult;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.result.table.XResultTable;
import org.eclipse.osee.framework.jdk.core.result.table.XResultTableColumn;
import org.eclipse.osee.framework.jdk.core.result.table.XResultTableDataType;
import org.eclipse.osee.framework.jdk.core.result.table.XResultTableRow;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.orcs.KeyValueOps;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.rest.internal.OrcsRestUtil;
import org.eclipse.osee.orcs.rest.internal.TransferDataStoreImpl;
import org.eclipse.osee.orcs.rest.model.Transaction;
import org.eclipse.osee.orcs.rest.model.TransactionEndpoint;
import org.eclipse.osee.orcs.rest.model.transaction.BranchLocation;
import org.eclipse.osee.orcs.rest.model.transaction.TransactionBuilderData;
import org.eclipse.osee.orcs.rest.model.transaction.TransactionBuilderDataFactory;
import org.eclipse.osee.orcs.rest.model.transaction.TransactionTransferManifest;
import org.eclipse.osee.orcs.rest.model.transaction.TransferDBType;
import org.eclipse.osee.orcs.rest.model.transaction.TransferFileLockUtil;
import org.eclipse.osee.orcs.rest.model.transaction.TransferInitData;
import org.eclipse.osee.orcs.rest.model.transaction.TransferOpType;
import org.eclipse.osee.orcs.rest.model.transaction.TransferTupleTypes;
import org.eclipse.osee.orcs.search.TupleQuery;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class TransactionEndpointImpl
implements TransactionEndpoint {
    private final OrcsApi orcsApi;
    private final IResourceManager resourceManager;
    private final TupleQuery tupleQuery;
    @Context
    private UriInfo uriInfo;

    public TransactionEndpointImpl(OrcsApi orcsApi, IResourceManager resourceManager) {
        this.orcsApi = orcsApi;
        this.resourceManager = resourceManager;
        this.tupleQuery = orcsApi.getQueryFactory().tupleQuery();
    }

    protected void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public List<Transaction> getAllTxs() {
        return OrcsRestUtil.asTransactions((ResultSet<? extends TransactionReadable>)this.orcsApi.getTransactionFactory().getAllTxs());
    }

    public Transaction getTx(TransactionId tx) {
        return OrcsRestUtil.asTransaction(this.orcsApi.getTransactionFactory().getTx(tx));
    }

    public TransactionResult create(TransactionBuilder tx) {
        TransactionToken token = tx.commit();
        TransactionResult result = new TransactionResult();
        result.setTx(token);
        XResultData resultData = new XResultData();
        resultData.setTxId(token.getIdString());
        resultData.setIds(tx.getTxDataReadables().stream().map(readable -> readable.getIdString()).collect(Collectors.toList()));
        result.setResults(resultData);
        result.setFailedGammas(tx.getGammaIdsFailed());
        return result;
    }

    public List<ChangeItem> compareTxs(TransactionId txId1, TransactionId txId2) {
        return this.orcsApi.getTransactionFactory().compareTxs(txId1, txId2);
    }

    public TransactionBuilderData exportTxsDiff(TransactionId txId1, TransactionId txId2) {
        TransactionBuilderDataFactory tbdf = new TransactionBuilderDataFactory(this.orcsApi, this.resourceManager);
        try {
            return tbdf.loadFromChanges(txId1, txId2);
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public Response setTxComment(TransactionId txId, String comment) {
        return OrcsRestUtil.asResponse(this.orcsApi.getTransactionFactory().setTxComment(txId, comment));
    }

    public Response purgeTxs(String txIds) {
        this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.OseeAccessAdmin});
        return OrcsRestUtil.asResponse(this.orcsApi.getTransactionFactory().purgeTxs(txIds));
    }

    public Response purgeUnusedBackingDataAndTransactions(int rowCount) {
        this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.OseeAccessAdmin});
        int[] rtn = this.orcsApi.getTransactionFactory().purgeUnusedBackingDataAndTransactions(rowCount);
        return Response.ok().entity((Object)Arrays.toString(rtn)).build();
    }

    public Response replaceWithBaselineTxVersion(BranchId branchId, TransactionId txId, ArtifactId artId, String comment) {
        return OrcsRestUtil.asResponse(this.orcsApi.getTransactionFactory().replaceWithBaselineTxVersion(branchId, txId, artId, comment));
    }

    public List<ChangeItem> getArtifactHistory(ArtifactId artifact, BranchId branch) {
        return this.orcsApi.getTransactionFactory().getArtifactHistory(artifact, branch);
    }

    public TransferInitData initTransactionTransfer(TransferInitData data) {
        int intDbType;
        ArrayList exportIdList;
        XResultData results = new XResultData();
        if (data == null) {
            TransferInitData example = new TransferInitData();
            BranchLocation bl = new BranchLocation();
            BranchLocation blCommon = new BranchLocation();
            blCommon.setBaseTxId(TransactionId.valueOf((int)500));
            blCommon.setBranchId(BranchId.valueOf((Long)570L));
            bl.setBaseTxId(TransactionId.valueOf((int)400));
            bl.setBranchId(BranchId.valueOf((Long)8L));
            example.setBranchLocations(Arrays.asList(blCommon, bl));
            example.setExportId(TransactionId.valueOf((Long)124388928743L));
            example.setTransferDBType(TransferDBType.SOURCE);
            results.error("null input given - fill out the returned json and use it to set properly init the transaction transfer");
            example.setResults(results);
            return example;
        }
        if (data.getTransferDBType().equals((Object)TransferDBType.DESTINATION)) {
            exportIdList = new ArrayList();
            intDbType = TransferDBType.DESTINATION.ordinal();
            this.tupleQuery.getTuple4E1FromTupleType(TransferTupleTypes.ExportedBranch, TransferTupleTypes.LongExportedDBType, Long.valueOf(intDbType), exportIdList::add);
            Iterator iterator = exportIdList.iterator();
            if (iterator.hasNext()) {
                TransactionId id = (TransactionId)iterator.next();
                if (id.equals(data.getExportId())) {
                    results.error(String.format("The export Id %s was already initialized.", data.getExportId().toString()));
                } else {
                    results.error(String.format("Another export Id, %s, was initialized. This database does not accept this export id %s.", id.toString(), data.getExportId().toString()));
                }
                data.setResults(results);
                return data;
            }
        } else if (data.getTransferDBType().equals((Object)TransferDBType.SOURCE)) {
            exportIdList = new ArrayList();
            intDbType = TransferDBType.SOURCE.ordinal();
            this.tupleQuery.getTuple4E1FromTupleType(TransferTupleTypes.ExportedBranch, TransferTupleTypes.LongExportedDBType, Long.valueOf(intDbType), exportIdList::add);
            for (TransactionId id : exportIdList) {
                if (!id.equals(data.getExportId())) continue;
                results.error(String.format("The export Id %s was already initialized.", data.getExportId().toString()));
                data.setResults(results);
                return data;
            }
        }
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, "Adding tuple for transfer init");
        List branchLocations = data.getBranchLocations();
        for (BranchLocation branchLoc : branchLocations) {
            tx.addTuple4(TransferTupleTypes.ExportedBranch, (Object)data.getExportId(), (Object)branchLoc.getBranchId(), (Object)branchLoc.getBaseTxId(), (Object)data.getTransferDBType());
            tx.addTuple4(TransferTupleTypes.TransferFile, (Object)branchLoc.getBranchId(), (Object)TransferOpType.PREV_TX, (Object)branchLoc.getBaseTxId(), (Object)TransactionId.valueOf((Long)Lib.generateUuid()));
        }
        tx.commit();
        return data;
    }

    public XResultData generateTransferFile(TransactionId exportId, String mode) {
        return this.generateTransferFileImpl(exportId, false, mode);
    }

    public XResultData reGenerateTransferFile(TransactionId exportId, String mode) {
        return this.generateTransferFileImpl(exportId, true, mode);
    }

    public XResultData generateTransferFileImpl(TransactionId exportId, boolean regen, String mode) {
        XResultData results = new XResultData();
        ArrayList exportIdList = new ArrayList();
        int intDbType = TransferDBType.SOURCE.ordinal();
        this.tupleQuery.getTuple4E1FromTupleType(TransferTupleTypes.ExportedBranch, TransferTupleTypes.LongExportedDBType, Long.valueOf(intDbType), exportIdList::add);
        boolean exportIdExist = false;
        for (TransactionId id : exportIdList) {
            if (!id.equals(exportId)) continue;
            exportIdExist = true;
            break;
        }
        if (!exportIdExist) {
            results.errorf("Export Id %s has not been initialized.", new Object[]{exportId.toString()});
            return results;
        }
        boolean islocked = false;
        try {
            if (TransferFileLockUtil.isLocked((KeyValueOps)this.orcsApi.getKeyValueOps(), (Long)exportId.getId())) {
                results.errorf("%s", new Object[]{"Lock is on. Transfer in progress for exportID", exportId.getIdString()});
                XResultData xResultData = results;
                return xResultData;
            }
            try {
                islocked = TransferFileLockUtil.lock((KeyValueOps)this.orcsApi.getKeyValueOps(), (Long)exportId.getId());
                TransferDataStoreImpl transfer = new TransferDataStoreImpl(this, this.orcsApi);
                results = transfer.transferTransactions(exportId, results, regen, mode);
            }
            catch (Exception ex) {
                results.errorf("%s", new Object[]{String.format("Error during generating transfer file: ", ex.getMessage())});
            }
        }
        finally {
            if (islocked) {
                TransferFileLockUtil.unLock((KeyValueOps)this.orcsApi.getKeyValueOps(), (Long)exportId.getId());
            }
        }
        return results;
    }

    public XResultData applyTransferFile(String location) {
        XResultData results;
        block11: {
            results = new XResultData();
            TransactionId exportId = TransactionId.SENTINEL;
            boolean islocked = false;
            try {
                TransactionTransferManifest manifest = new TransactionTransferManifest();
                results = manifest.parse(location);
                if (results.isSuccess()) {
                    results = manifest.validate(this.tupleQuery);
                }
                if (results.isFailed()) {
                    XResultData xResultData = results;
                    return xResultData;
                }
                try {
                    exportId = manifest.getExportID();
                    if (TransferFileLockUtil.isLocked((KeyValueOps)this.orcsApi.getKeyValueOps(), (Long)exportId.getId())) {
                        results.error("Lock is on; Another upload process is in progress. ");
                        break block11;
                    }
                    islocked = TransferFileLockUtil.lock((KeyValueOps)this.orcsApi.getKeyValueOps(), (Long)exportId.getId());
                    results = manifest.importAllTransactions(this.orcsApi, this.resourceManager);
                    if (results.isFailed()) {
                        manifest.purgeAllImportedTransaction(this.orcsApi);
                        break block11;
                    }
                    results = manifest.addAllImportedTransToTupleTable(this.orcsApi);
                    results.log(String.format("Imported succesfully the transaction ids: %s. ", manifest.getAllImportedTransIds().toString()));
                }
                catch (Exception ex) {
                    results.errorf("%s", new Object[]{String.format("Error during uploading transfer file: ", ex.getMessage())});
                }
            }
            finally {
                if (islocked) {
                    TransferFileLockUtil.unLock((KeyValueOps)this.orcsApi.getKeyValueOps(), (Long)exportId.getId());
                }
            }
        }
        return results;
    }

    public XResultData getTransferFileList(final String strexportId) {
        XResultData results = new XResultData();
        try {
            String transferPath = String.valueOf(this.orcsApi.getSystemProperties().getValue("osee.application.server.data")) + File.separator + TransferDataStoreImpl.transferDir + File.separator;
            File directoryPath = new File(transferPath);
            FilenameFilter filefilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    String lowercaseName = name.toLowerCase();
                    if (!lowercaseName.endsWith(".zip")) {
                        return false;
                    }
                    if (strexportId == null) {
                        return true;
                    }
                    return lowercaseName.contains(strexportId);
                }
            };
            List<String> filelist = Arrays.asList(directoryPath.list(filefilter));
            if (filelist.size() > 0) {
                results.setInfoCount(filelist.size());
                results.setIds(filelist);
            }
        }
        catch (Exception ex) {
            results.error(ex.getMessage());
        }
        return results;
    }

    public XResultData getExportIdList() {
        XResultData results = new XResultData();
        try {
            ArrayList exportIdList = new ArrayList();
            int intDbType = TransferDBType.SOURCE.ordinal();
            this.tupleQuery.getTuple4E1FromTupleType(TransferTupleTypes.ExportedBranch, TransferTupleTypes.LongExportedDBType, Long.valueOf(intDbType), exportIdList::add);
            ArrayList<String> idlist = new ArrayList<String>();
            for (TransactionId transId : exportIdList) {
                idlist.add(transId.getIdString());
            }
            if (exportIdList.size() > 0) {
                results.setInfoCount(exportIdList.size());
                results.setIds(idlist);
            }
        }
        catch (Exception ex) {
            results.error(ex.getMessage());
        }
        return results;
    }

    public XResultData getExportData(final String strexportId) {
        XResultData results = new XResultData();
        XResultTable exportData = new XResultTable();
        List<XResultTableColumn> dataColumns = Arrays.asList(new XResultTableColumn(Columns.Source.name(), Columns.Source.name(), 100, XResultTableDataType.String), new XResultTableColumn(Columns.Date.name(), Columns.Date.name(), 100, XResultTableDataType.String), new XResultTableColumn(Columns.File.name(), Columns.File.name(), 100, XResultTableDataType.String));
        ArrayList<String> sources = new ArrayList<String>();
        ArrayList<String> dates = new ArrayList<String>();
        ArrayList<String> files = new ArrayList<String>();
        try {
            String transferPath = String.valueOf(this.orcsApi.getSystemProperties().getValue("osee.application.server.data")) + File.separator + TransferDataStoreImpl.transferDir + File.separator;
            File directoryPath = new File(transferPath);
            FilenameFilter filefilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    String lowercaseName = name.toLowerCase();
                    if (!lowercaseName.endsWith(".zip")) {
                        return false;
                    }
                    if (strexportId == null) {
                        return true;
                    }
                    return lowercaseName.contains(strexportId);
                }
            };
            List<String> filelist = Arrays.asList(directoryPath.list(filefilter));
            String exportId = "";
            String date = "";
            String file = "";
            String data = "";
            if (filelist.size() > 0) {
                int i = 0;
                while (i < filelist.size()) {
                    file = data = filelist.get(i).toString();
                    String[] export = data.split("-");
                    exportId = export[1];
                    date = TransactionEndpointImpl.convertTimestamp(export[2]);
                    sources.add(exportId);
                    dates.add(date);
                    files.add(file);
                    ++i;
                }
                if (sources != null) {
                    exportData.setName("TFG Data");
                    exportData.getColumns().addAll(dataColumns);
                    int x = 0;
                    while (x < sources.size()) {
                        exportData.getRows().add(new XResultTableRow(new String[]{String.valueOf(sources.get(x)), String.valueOf(dates.get(x)), String.valueOf(files.get(x))}));
                        ++x;
                    }
                    HashSet uniqueSet = new HashSet(sources);
                    ArrayList sortedSources = new ArrayList(uniqueSet);
                    Collections.sort(sortedSources);
                    results.setInfoCount(filelist.size());
                    results.getTables().add(exportData);
                    results.setTitle("Transfer File: Export Directory Data");
                    results.getResults().addAll(filelist);
                }
            }
            ArrayList exportIdList = new ArrayList();
            int intDbType = TransferDBType.SOURCE.ordinal();
            this.tupleQuery.getTuple4E1FromTupleType(TransferTupleTypes.ExportedBranch, TransferTupleTypes.LongExportedDBType, Long.valueOf(intDbType), exportIdList::add);
            ArrayList<String> idlist = new ArrayList<String>();
            for (TransactionId transId : exportIdList) {
                idlist.add(transId.getIdString());
            }
            if (exportIdList.size() > 0) {
                results.setIds(idlist);
            }
        }
        catch (Exception ex) {
            results.error(ex.getMessage().toString());
        }
        return results;
    }

    public static String convertTimestamp(String timestampString) {
        int year = Integer.parseInt(timestampString.substring(0, 4));
        int month = Integer.parseInt(timestampString.substring(4, 6)) - 1;
        int day = Integer.parseInt(timestampString.substring(6, 8));
        int hour = Integer.parseInt(timestampString.substring(8, 10));
        int minute = Integer.parseInt(timestampString.substring(10, 12));
        Date date = new Date(year - 1900, month, day, hour, minute);
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
        return sdf.format(date);
    }

    public Response downloadTransferFile(String filename) {
        String transferPath = String.valueOf(this.orcsApi.getSystemProperties().getValue("osee.application.server.data")) + File.separator + TransferDataStoreImpl.transferDir;
        File downloadZip = new File(String.format("%s%s%s", transferPath, File.separator, filename));
        if (downloadZip.exists()) {
            try {
                return Response.ok((Object)Files.readAllBytes(downloadZip.toPath())).type("application/zip").header("Content-Disposition", (Object)("attachment; filename=\"" + filename + "\"")).build();
            }
            catch (IOException iOException) {
                return Response.serverError().build();
            }
        }
        return Response.noContent().build();
    }

    private String unzipTransferFile(InputStream zip) throws IOException {
        File serverApplicDir;
        String serverDataPath = this.orcsApi.getSystemProperties().getValue("osee.application.server.data");
        if (serverDataPath == null) {
            serverDataPath = System.getProperty("user.home");
        }
        if (!(serverApplicDir = new File(String.format("%s%sOSEEDataTransferUploads", serverDataPath, File.separator))).exists()) {
            serverApplicDir.mkdirs();
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (FileWriter readme = new FileWriter(String.format("%s%s%s", serverApplicDir.getPath(), File.separator, "readme.txt"));){
                    readme.write("This folder contains OSEE data transfer files which were imported during debugging");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new OseeCoreException((Throwable)e, "Failed to create directory. ", new Object[0]);
            }
        }
        Date date = Calendar.getInstance().getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyymmmdd_hhmmss");
        String timedId = String.format("%sOSEETransferFile-%s", File.separator, dateFormat.format(date));
        String timedIdDir = String.format("%s%s%s", serverApplicDir.getPath(), File.separator, timedId);
        FileOutputStream outStream = null;
        ZipInputStream zis = null;
        String returnDir = timedIdDir;
        try {
            try {
                new File(timedIdDir).mkdir();
                String fileZip = String.format("%s.zip", timedIdDir);
                File uploadedZip = new File(fileZip);
                byte[] buffer = zip.readAllBytes();
                outStream = new FileOutputStream(uploadedZip);
                ((OutputStream)outStream).write(buffer);
                zis = new ZipInputStream(new FileInputStream(fileZip));
                ZipEntry zipEntry = zis.getNextEntry();
                File unzipLocation = new File(timedIdDir);
                unzipLocation.mkdirs();
                while (zipEntry != null) {
                    File uploadedDirectory = new File(unzipLocation, zipEntry.getName());
                    if (zipEntry.isDirectory()) {
                        if (!uploadedDirectory.isDirectory() && !uploadedDirectory.mkdirs()) {
                            zis.close();
                            Lib.close((AutoCloseable)outStream);
                            throw new IOException("Failed to create directory " + uploadedDirectory);
                        }
                    } else {
                        File parent = uploadedDirectory.getParentFile();
                        if (!parent.isDirectory() && !parent.mkdirs()) {
                            zis.close();
                            Lib.close((AutoCloseable)outStream);
                            throw new IOException("Failed to create directory " + parent);
                        }
                        Throwable throwable = null;
                        Object var19_24 = null;
                        try (FileOutputStream fos = new FileOutputStream(uploadedDirectory);){
                            int len;
                            while ((len = zis.read(buffer)) > 0) {
                                fos.write(buffer, 0, len);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    zipEntry = zis.getNextEntry();
                }
            }
            catch (IOException ex) {
                throw new OseeCoreException((Throwable)ex, "OSEE Upload Transfer file Failed. ", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            zip.close();
            Lib.close(outStream);
            Lib.close(zis);
            throw throwable;
        }
        zip.close();
        Lib.close((AutoCloseable)outStream);
        Lib.close((AutoCloseable)zis);
        return returnDir;
    }

    public XResultData uploadTransferFile(InputStream zip) {
        XResultData results = new XResultData();
        String transDir = "";
        try {
            try {
                transDir = this.unzipTransferFile(zip);
                zip.close();
            }
            catch (Exception exception) {
                results.error("Failed to unzip the file.");
                XResultData xResultData = results;
                if (zip != null) {
                    Lib.close((AutoCloseable)zip);
                }
                return xResultData;
            }
        }
        finally {
            if (zip != null) {
                Lib.close((AutoCloseable)zip);
            }
        }
        results = this.applyTransferFile(transDir);
        String parentPath = Paths.get(transDir, new String[0]).getParent().toString();
        try {
            File importTransferFolder;
            if (parentPath.endsWith("OSEEDataTransferUploads") && (importTransferFolder = new File(parentPath)).exists()) {
                this.deleteDir(importTransferFolder);
            }
        }
        catch (Exception e) {
            results.error("Transfer folder for deletion not found. " + e.getMessage());
        }
        return results;
    }

    public XResultData lock(TransactionId exportId) {
        XResultData results = new XResultData();
        boolean transferLocked = TransferFileLockUtil.lock((KeyValueOps)this.orcsApi.getKeyValueOps(), (Long)exportId.getId());
        if (transferLocked) {
            results.logf("Export ID locked: %s", new Object[]{exportId.toString()});
        } else {
            results.errorf("Export ID %s already locked", new Object[]{exportId.toString()});
        }
        return results;
    }

    public XResultData unlock(TransactionId exportId) {
        XResultData results = new XResultData();
        boolean transferUnLocked = TransferFileLockUtil.unLock((KeyValueOps)this.orcsApi.getKeyValueOps(), (Long)exportId.getId());
        if (transferUnLocked) {
            results.logf("Export ID unlocked: %s", new Object[]{exportId.toString()});
        } else {
            results.errorf("Export ID %s already not locked", new Object[]{exportId.toString()});
        }
        return results;
    }

    public XResultData isLocked(TransactionId exportId) {
        XResultData results = new XResultData();
        boolean transferIsLocked = TransferFileLockUtil.isLocked((KeyValueOps)this.orcsApi.getKeyValueOps(), (Long)exportId.getId());
        if (transferIsLocked) {
            results.logf("Export ID locked: %s", new Object[]{exportId.toString()});
        } else {
            results.logf("Export ID %s not locked", new Object[]{exportId.toString()});
        }
        return results;
    }

    private void deleteDir(File file) {
        File[] contents = file.listFiles();
        if (contents != null) {
            File[] fileArray = contents;
            int n = contents.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (!Files.isSymbolicLink(f.toPath())) {
                    this.deleteDir(f);
                }
                ++n2;
            }
        }
        file.delete();
    }

    public static enum Columns {
        Source,
        Date,
        File;

    }
}

