/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import java.util.List;
import javax.ws.rs.core.Response;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.exception.RelTableInvalidException;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.model.RelationEndpoint;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class RelationEndpointImpl
implements RelationEndpoint {
    private final OrcsApi orcsApi;
    private final BranchId branch;

    public RelationEndpointImpl(OrcsApi orcsApi, BranchId branch) {
        this.orcsApi = orcsApi;
        this.branch = branch;
    }

    public Response createRelationByType(ArtifactId sideA, ArtifactId sideB, RelationTypeToken relationType) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, String.format("RelationEndpoint REST api creating relation %s between %s and %s", relationType.getName(), sideA.getIdString(), sideB.getIdString()));
        tx.relate(sideA, relationType, sideB);
        tx.commit();
        return Response.ok().build();
    }

    public List<ArtifactToken> getRelatedHierarchy(ArtifactId artifact, ArtifactId view) {
        List<ArtifactToken> ids = this.getRelated(artifact, CoreRelationTypes.DefaultHierarchical, RelationSide.SIDE_A, view);
        return ids;
    }

    private List<ArtifactToken> getRelated(ArtifactId artifact, RelationTypeToken relationType, RelationSide side, ArtifactId view) {
        RelationTypeSide rts = new RelationTypeSide(relationType, side);
        return this.orcsApi.getQueryFactory().fromBranch(this.branch, view).andRelatedTo(rts, artifact).asArtifactTokens();
    }

    public List<ArtifactToken> getRelatedRecursive(ArtifactId artifact, RelationTypeToken relationType, ArtifactId view) {
        RelationTypeSide sideB = new RelationTypeSide(relationType, RelationSide.SIDE_B);
        return this.orcsApi.getQueryFactory().fromBranch(this.branch, view).andRelatedRecursive(sideB, artifact).asArtifactTokens();
    }

    public List<RelationTypeToken> convertRelations(ArtifactId artToken, RelationTypeToken oldRelationType, RelationTypeToken newRelationType) {
        RelationTypeSide sideB = new RelationTypeSide(oldRelationType, RelationSide.SIDE_B);
        ArtifactReadable art = this.orcsApi.getQueryFactory().fromBranch(this.branch).andId(artToken).asArtifact();
        if (art.getRelatedCount(sideB) > 0) {
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, String.format("Converting relations for artifact %s.  Old Relation = %s New Relation = %s", artToken.getIdString(), newRelationType.getName(), oldRelationType.getName()));
            for (ArtifactReadable artB : art.getRelated(sideB).getList()) {
                tx.relate((ArtifactId)art, newRelationType, (ArtifactId)artB);
            }
            tx.commit();
        }
        return null;
    }

    public TransactionToken convertAllRelations(RelationTypeToken oldRelationType, RelationTypeToken newRelationType) {
        RelationTypeSide sideB = new RelationTypeSide(oldRelationType, RelationSide.SIDE_B);
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, String.format("Converting relations for Old Relation = %s New Relation = %s", oldRelationType.getName(), newRelationType.getName()));
        for (ArtifactReadable art : this.orcsApi.getQueryFactory().fromBranch(this.branch).andRelationExists(oldRelationType).getResults().getList()) {
            if (art.getRelatedCount(sideB) <= 0) continue;
            for (ArtifactReadable artB : art.getRelated(sideB).getList()) {
                tx.relate((ArtifactId)art, newRelationType, (ArtifactId)artB);
            }
        }
        return tx.commit();
    }

    public String validateRel2Table() {
        int count = (Integer)this.orcsApi.getJdbcService().getClient().fetch((Object)0, "select count(*) from (select distinct rel_type, a_art_id, rel_order, cnt\nfrom\n(select rel_type, a_art_id, b_art_id, rel_order, count('x') over (partition by rel_type, a_art_id, rel_order) cnt\nfrom osee_relation rel where rel_order > 0) t1\nwhere cnt > 1) t2", new Object[0]);
        if (count > 0) {
            throw new RelTableInvalidException("Invalid relations detected. Count: %s", new Object[]{count});
        }
        return "<html><div>Relations Valid</div></html>";
    }
}

