/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.model.dto.HelpPageDto;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.model.HelpEndpoint;

public final class HelpEndpointImpl
implements HelpEndpoint {
    private final OrcsApi orcsApi;

    public HelpEndpointImpl(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public List<HelpPageDto> getHelp(String appName) {
        Stream<HelpPageDto> helpPages = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.HelpPage}).follow(CoreRelationTypes.HelpToHelp_Child).asArtifacts().stream().map(a -> new HelpPageDto(a));
        if (appName != null && !appName.isEmpty()) {
            helpPages = helpPages.filter(h -> h.getAppName().toLowerCase().equals(appName.toLowerCase()));
        }
        List<HelpPageDto> appHelpPages = helpPages.collect(Collectors.toList());
        List<HelpPageDto> children = this.getAllChildren(appHelpPages);
        return appHelpPages.stream().filter(p -> !children.contains(p)).collect(Collectors.toList());
    }

    public HelpPageDto getHelpPage(String id) {
        if (id != null) {
            ArtifactReadable art = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId(ArtifactId.valueOf((String)id)).asArtifact();
            return new HelpPageDto(art);
        }
        return new HelpPageDto();
    }

    private List<HelpPageDto> getAllChildren(List<HelpPageDto> helpPages) {
        LinkedList<HelpPageDto> children = new LinkedList<HelpPageDto>();
        for (HelpPageDto page : helpPages) {
            if (page.getChildren().isEmpty()) continue;
            children.addAll(page.getChildren());
            children.addAll(this.getAllChildren(page.getChildren()));
        }
        return children;
    }
}

