/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.ApiKeyApi;
import org.eclipse.osee.framework.core.data.ApiKey;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.UserService;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.orcs.OrcsAdmin;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.model.ApiKeyEndpoint;

public class ApiKeyEndpointImpl
implements ApiKeyEndpoint {
    @Context
    private final ActivityLog activityLog;
    private final OrcsAdmin adminOps;
    private final UserService userService;
    private final JdbcService jdbcService;
    private final ApiKeyApi apiKeyApi;

    public ApiKeyEndpointImpl(OrcsApi orcsApi, ActivityLog activityLog, JdbcService jdbcService, ApiKeyApi apiKeyApi) {
        this.activityLog = activityLog;
        this.jdbcService = jdbcService;
        this.apiKeyApi = apiKeyApi;
        this.adminOps = orcsApi.getAdminOps();
        this.userService = orcsApi.userService();
    }

    public Response getApiKeys() {
        List apiKeys = this.apiKeyApi.getApiKeys((ArtifactId)this.userService.getUser().getToken());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)apiKeys).build();
    }

    public Response getKeyScopes() {
        List keyScopes = this.apiKeyApi.getKeyScopes();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)keyScopes).build();
    }

    public Response createApiKey(ApiKey apiKey) {
        Map uidAndValue = this.apiKeyApi.createApiKey(apiKey, (ArtifactId)this.userService.getUser().getToken());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)uidAndValue).build();
    }

    public Response revokeApiKey(long keyUID) {
        boolean revokeSuccess = this.apiKeyApi.revokeApiKey(keyUID);
        if (revokeSuccess) {
            return Response.ok((Object)("Api Key With {ID: " + keyUID + "} Successfully Revoked"), (String)"text/plain").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Failed To Revoke Api Key With {ID: " + keyUID + "}")).type("text/plain").build();
    }
}

