/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.admin;

import org.eclipse.osee.account.admin.AccessDetails;
import org.eclipse.osee.account.admin.AccountLoginRequest;

public final class AccountLoginRequestBuilder {
    private String scheme;
    private String userName;
    private String password;
    private String accessDetails;
    private String remoteAddress;

    private AccountLoginRequestBuilder() {
    }

    public static AccountLoginRequestBuilder newBuilder() {
        return new AccountLoginRequestBuilder();
    }

    public AccountLoginRequestBuilder scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public AccountLoginRequestBuilder userName(String userName) {
        this.userName = userName;
        return this;
    }

    public AccountLoginRequestBuilder password(String password) {
        this.password = password;
        return this;
    }

    public AccountLoginRequestBuilder accessedBy(String accessDetails) {
        this.accessDetails = accessDetails;
        return this;
    }

    public AccountLoginRequestBuilder remoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }

    public AccountLoginRequest build() {
        LoginAccessDetailsImpl details = new LoginAccessDetailsImpl(this.accessDetails, this.remoteAddress);
        return new LoginAccountRequestImpl(this.scheme, this.userName, this.password, details);
    }

    private static final class LoginAccessDetailsImpl
    implements AccessDetails {
        private final String accessDetails;
        private final String remoteAddress;

        public LoginAccessDetailsImpl(String accessDetails, String remoteAddress) {
            this.accessDetails = accessDetails;
            this.remoteAddress = remoteAddress;
        }

        @Override
        public String getAccessDetails() {
            return this.accessDetails;
        }

        @Override
        public String getRemoteAddress() {
            return this.remoteAddress;
        }
    }

    private static final class LoginAccountRequestImpl
    implements AccountLoginRequest {
        private final String userName;
        private final String password;
        private final String scheme;
        private final AccessDetails accessDetails;

        public LoginAccountRequestImpl(String scheme, String userName, String password, AccessDetails accessDetails) {
            this.scheme = scheme;
            this.userName = userName;
            this.password = password;
            this.accessDetails = accessDetails;
        }

        @Override
        public String getScheme() {
            return this.scheme;
        }

        @Override
        public String getUserName() {
            return this.userName;
        }

        @Override
        public String getPassword() {
            return this.password;
        }

        @Override
        public AccessDetails getDetails() {
            return this.accessDetails;
        }

        public String toString() {
            return "LoginAccountRequestImpl [scheme=" + this.scheme + ", userName=" + this.userName + ", password=[******]]";
        }
    }
}

