/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.note;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.note.AtsStateNote;
import org.eclipse.osee.ats.api.workflow.note.AtsStateNoteType;
import org.eclipse.osee.ats.api.workflow.note.IAtsStateNoteService;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.logging.OseeLog;

public class AtsStateNoteServiceImpl
implements IAtsStateNoteService {
    private final AtsApi atsApi;

    public AtsStateNoteServiceImpl(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public void addNote(IAtsWorkItem workItem, AtsStateNoteType type, String state, String msg, IAtsChangeSet changes) {
        this.addNote(workItem, type, state, msg, new Date(), (UserId)this.atsApi.userService().getUser(), changes);
    }

    public void addNote(IAtsWorkItem workItem, AtsStateNoteType type, String state, String msg, Date date, UserId user, IAtsChangeSet changes) {
        AtsStateNote note = new AtsStateNote(type.getName(), state, String.valueOf(date.getTime()), UserId.valueOf((Long)user.getId()), msg);
        this.addNote(workItem, note, changes);
    }

    public void addNote(IAtsWorkItem workItem, AtsStateNote note, IAtsChangeSet changes) {
        String json = this.getNoteAsJson(note);
        changes.addAttribute((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.StateNotes, (Object)json);
    }

    public void addNote(IAtsWorkItem workItem, AtsStateNote note) {
        IAtsChangeSet changes = this.atsApi.createChangeSet("Add State Note");
        this.addNote(workItem, note, changes);
        changes.executeIfNeeded();
    }

    public List<AtsStateNote> getNotes(IAtsWorkItem workItem) {
        ArrayList<AtsStateNote> notes = new ArrayList<AtsStateNote>();
        try {
            for (String json : this.atsApi.getAttributeResolver().getAttributesToStringList((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.StateNotes)) {
                if (!json.startsWith("{")) continue;
                AtsStateNote note = this.getNoteFromJson(json);
                UserId userArtId = note.getUser();
                AtsUser user = this.atsApi.getUserService().getUserById((ArtifactId)userArtId);
                note.setUserTok(user.getArtifactToken());
                notes.add(note);
            }
        }
        catch (Exception ex) {
            OseeLog.log(AtsStateNoteServiceImpl.class, (Level)Level.SEVERE, (String)"Error extracting note", (Throwable)ex);
        }
        return notes;
    }

    public String getNoteAsJson(AtsStateNote note) {
        return this.atsApi.jaxRsApi().toJson((Object)note);
    }

    public AtsStateNote getNoteFromJson(String jsonNote) {
        return (AtsStateNote)this.atsApi.jaxRsApi().readValue(jsonNote, AtsStateNote.class);
    }

    public String getTable(IAtsWorkItem workItem, String state) {
        if (!this.isNoteable(workItem)) {
            return "";
        }
        ArrayList<AtsStateNote> showNotes = new ArrayList<AtsStateNote>();
        List<AtsStateNote> noteItems = this.getNotes(workItem);
        for (AtsStateNote li : noteItems) {
            if (state == null && li.getState().equals("")) {
                showNotes.add(li);
                continue;
            }
            if (state == null || !"ALL".equals(state) && !li.getState().equals(state)) continue;
            showNotes.add(li);
        }
        if (showNotes.isEmpty()) {
            return "";
        }
        return this.toHtmlTable(showNotes);
    }

    private String toHtmlTable(List<AtsStateNote> showNotes) {
        StringBuilder builder = new StringBuilder();
        builder.append(AHTML.beginMultiColumnTable((int)100, (int)1));
        builder.append(AHTML.addHeaderRowMultiColumnTable(Arrays.asList("Type", "State", "Message", "User", "Date")));
        DateFormat dateFormat = this.getDateFormat();
        for (AtsStateNote note : showNotes) {
            String name = note.getUserName();
            builder.append(AHTML.addRowMultiColumnTable((String[])new String[]{String.valueOf(note.getType()), note.getState().isEmpty() ? "," : note.getState(), note.getMsg().equals("") ? "," : note.getMsg(), name, dateFormat.format(note.getDate())}));
        }
        builder.append(AHTML.endMultiColumnTable());
        return builder.toString();
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("MM/dd/yyyy h:mm a", Locale.US);
    }

    public String getNoteTitle(IAtsWorkItem workItem) {
        return "History for \"" + this.atsApi.getStoreService().getArtifactType((ArtifactId)workItem.getStoreObject()).getName() + "\" - " + workItem.getId() + " - titled \"" + workItem.getName() + "\"";
    }

    public boolean isNoteable(IAtsWorkItem workItem) {
        return this.atsApi.getStoreService().isAttributeTypeValid((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.StateNotes);
    }

    public boolean removeNote(IAtsWorkItem workItem, AtsStateNote note) {
        boolean changed = false;
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("Remove State Note");
        changed = this.removeNote(workItem, note, changes);
        if (changed) {
            changes.executeIfNeeded();
        }
        return changed;
    }

    public boolean removeNote(IAtsWorkItem workItem, AtsStateNote note, IAtsChangeSet changes) {
        IAttribute<Object> matchAttr = this.getNoteAttr(workItem, note);
        if (matchAttr == null) {
            return false;
        }
        changes.deleteAttribute(workItem, matchAttr);
        return true;
    }

    public boolean updateNote(IAtsWorkItem workItem, AtsStateNote note, String newMsg, IAtsChangeSet changes) {
        IAttribute<Object> matchAttr = this.getNoteAttr(workItem, note);
        if (matchAttr == null) {
            return false;
        }
        changes.deleteAttribute(workItem, matchAttr);
        this.atsApi.getWorkItemService().getStateNoteService().addNote(workItem, note.getTypeEnum(), note.getState(), newMsg, changes);
        return true;
    }

    public boolean updateNote(IAtsWorkItem workItem, AtsStateNote note, String newMsg) {
        boolean changed = false;
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("Update State Note");
        changed = this.updateNote(workItem, note, newMsg, changes);
        if (changed) {
            changes.executeIfNeeded();
        }
        return changed;
    }

    private IAttribute<Object> getNoteAttr(IAtsWorkItem workItem, AtsStateNote note) {
        IAttribute matchAttr = null;
        for (IAttribute attr : AtsApiService.get().getAttributeResolver().getAttributes((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.StateNotes)) {
            String value = (String)attr.getValue();
            if (!value.contains(note.getId().toString())) continue;
            matchAttr = attr;
            break;
        }
        return matchAttr;
    }
}

