/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.log;

import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workflow.log.ILogStorageProvider;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;

public class AtsLogStoreProvider
implements ILogStorageProvider {
    private final IAttributeResolver attrResolver;
    private final IAtsWorkItem workItem;

    public AtsLogStoreProvider(IAtsWorkItem workItem, IAttributeResolver attrResolver) {
        this.workItem = workItem;
        this.attrResolver = attrResolver;
    }

    public String getLogXml() {
        try {
            return (String)this.attrResolver.getSoleAttributeValue((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.Log, (Object)"");
        }
        catch (OseeCoreException ex) {
            OseeLog.log(AtsLogStoreProvider.class, (Level)Level.SEVERE, (Throwable)ex);
            return "getLogXml exception " + ex.getLocalizedMessage();
        }
    }

    public Result saveLogXml(String xml, IAtsChangeSet changes) {
        try {
            this.attrResolver.setSoleAttributeValue((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.Log, (Object)xml, changes);
            return Result.TrueResult;
        }
        catch (OseeCoreException ex) {
            OseeLog.log(AtsLogStoreProvider.class, (Level)Level.SEVERE, (Throwable)ex);
            return new Result("saveLogXml exception " + ex.getLocalizedMessage());
        }
    }

    public String getLogTitle() {
        try {
            return "History for \"" + this.workItem.getArtifactTypeName() + "\" - " + this.getLogId() + " - titled \"" + this.workItem.getName() + "\"";
        }
        catch (OseeCoreException ex) {
            OseeLog.log(AtsLogStoreProvider.class, (Level)Level.SEVERE, (Throwable)ex);
            return "getLogTitle exception " + ex.getLocalizedMessage();
        }
    }

    public String getLogId() {
        return this.workItem.getAtsId();
    }
}

