/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.hooks;

import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsTransitionHook;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.logging.OseeLog;

public class AtsArchiveBranchWhenCompleteHook
implements IAtsTransitionHook {
    public String getName() {
        return AtsArchiveBranchWhenCompleteHook.class.getSimpleName();
    }

    public String getDescription() {
        return "When the Workflow is transitioned to Completed, archive the branch, if it is not already archived.";
    }

    public boolean isBackgroundTask(Collection<IAtsWorkItem> workItems, Map<IAtsWorkItem, String> workItemFromStateMap, String toStateName, AtsUser transitionUser, AtsApi atsApi) {
        for (IAtsWorkItem workItem : workItems) {
            StateDefinition toStateDef;
            if (!workItem.isTeamWorkflow() || !(toStateDef = workItem.getWorkDefinition().getStateByName(toStateName)).isCompleted()) continue;
            return true;
        }
        return false;
    }

    public void transitionPersistedBackground(Collection<? extends IAtsWorkItem> workItems, Map<IAtsWorkItem, String> workItemFromStateMap, String toStateName, AtsUser asUser, AtsApi atsApi) {
        try {
            for (IAtsWorkItem iAtsWorkItem : workItems) {
                BranchToken branch;
                StateDefinition toStateDef;
                if (!iAtsWorkItem.isTeamWorkflow() || !(toStateDef = iAtsWorkItem.getWorkDefinition().getStateByName(toStateName)).isCompleted() || (branch = atsApi.getBranchService().getWorkingBranch((IAtsTeamWorkflow)iAtsWorkItem, true)) == null || !branch.isValid() || atsApi.getBranchService().isArchived((BranchId)branch)) continue;
                atsApi.getBranchService().archiveBranch((BranchId)branch);
            }
        }
        catch (Exception exception) {
            OseeLog.log(AtsArchiveBranchWhenCompleteHook.class, (Level)Level.SEVERE, (String)"Error archiving branch in complete hook", (Throwable)exception);
        }
    }
}

