/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.log;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.log.IAtsLog;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogItem;
import org.eclipse.osee.ats.api.workflow.log.LogType;
import org.eclipse.osee.ats.core.internal.log.LogItem;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLog;

public class AtsLog
implements IAtsLog {
    private boolean dirty = false;
    private final List<IAtsLogItem> logItems = new ArrayList<IAtsLogItem>();
    private String logId = "none";

    public String toString() {
        try {
            return Collections.toString((String)"\n", this.getLogItems());
        }
        catch (Exception ex) {
            OseeLog.log(AtsLog.class, (Level)Level.SEVERE, (Throwable)ex);
            return ex.getLocalizedMessage();
        }
    }

    public Date getLastStatusDate() {
        IAtsLogItem logItem = this.getLastEvent(LogType.Metrics);
        if (logItem == null) {
            return null;
        }
        return logItem.getDate();
    }

    public List<IAtsLogItem> getLogItemsReversed() {
        ArrayList<IAtsLogItem> logItems = new ArrayList<IAtsLogItem>(this.getLogItems());
        java.util.Collections.reverse(logItems);
        return logItems;
    }

    public Collection<IAtsLogItem> getLogItems(LogType logType) {
        ArrayList<IAtsLogItem> items = new ArrayList<IAtsLogItem>();
        for (IAtsLogItem logItem : this.logItems) {
            if (!logItem.getType().equals((Object)logType)) continue;
            items.add(logItem);
        }
        return items;
    }

    public IAtsLogItem getLogItemWithTypeAsOfDate(LogType logType, Date date) {
        IAtsLogItem retLogItem = null;
        for (IAtsLogItem logItem : this.logItems) {
            if (!logItem.getType().equals((Object)logType)) continue;
            Date logItemDate = logItem.getDate();
            if (logItemDate.after(date)) break;
            retLogItem = logItem;
        }
        return retLogItem;
    }

    public void internalResetCreatedDate(Date date) {
        List<IAtsLogItem> logItems = this.getLogItems();
        for (IAtsLogItem item : logItems) {
            if (item.getType() != LogType.Originated) continue;
            item.setDate(date);
            this.dirty = true;
            return;
        }
    }

    public String internalGetCancelledReason() {
        IAtsLogItem item = this.getStateEvent(LogType.StateCancelled);
        if (item == null) {
            return "";
        }
        return item.getMsg();
    }

    public String internalGetCompletedFromState() {
        IAtsLogItem item = this.getStateEvent(LogType.StateComplete);
        if (item == null) {
            return "";
        }
        return item.getState();
    }

    public IAtsLogItem addLogItem(IAtsLogItem item) {
        return this.addLog(item.getType(), item.getState(), item.getMsg(), item.getDate(), item.getUserId());
    }

    public IAtsLogItem addLog(LogType logType, String state, String msg, String userId) {
        return this.addLog(logType, state, msg, new Date(), userId);
    }

    public IAtsLogItem addLog(LogType logType, String state, String msg, Date date, String userId) {
        LogItem logItem = new LogItem(logType, date, userId, state, msg);
        List<IAtsLogItem> logItems = this.getLogItems();
        logItems.add(logItem);
        this.dirty = true;
        return logItem;
    }

    public void clearLog() {
        this.logItems.clear();
        this.dirty = true;
    }

    public IAtsLogItem getLastEvent(LogType logType) {
        for (IAtsLogItem item : this.getLogItemsReversed()) {
            if (item.getType() != logType) continue;
            return item;
        }
        return null;
    }

    public IAtsLogItem getStateEvent(LogType logType, String stateName) {
        for (IAtsLogItem item : this.getLogItemsReversed()) {
            if (item.getType() != logType || !item.getState().equals(stateName)) continue;
            return item;
        }
        return null;
    }

    public IAtsLogItem getStateEvent(LogType logType) {
        for (IAtsLogItem item : this.getLogItemsReversed()) {
            if (item.getType() != logType) continue;
            return item;
        }
        return null;
    }

    public List<IAtsLogItem> getLogItems() {
        return this.logItems;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void setLogId(String logId) {
        this.logId = logId;
    }

    public String getLogId() {
        return this.logId;
    }

    public List<String> getVisitedStateNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (IAtsLogItem item : this.getLogItems(LogType.StateEntered)) {
            if (names.contains(item.getState())) continue;
            names.add(item.getState());
        }
        return names;
    }

    public boolean isStateVisited(IStateToken state) {
        return this.isStateVisited(state.getName());
    }

    public boolean isStateVisited(String stateName) {
        for (IAtsLogItem item : this.getLogItems(LogType.StateEntered)) {
            if (!item.getState().equals(stateName)) continue;
            return true;
        }
        return false;
    }
}

