/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.demo;

import java.rmi.activation.Activator;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.demo.DemoArtifactToken;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.DemoBranches;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLog;

public class DemoUtil {
    private static String atsIds;
    public static List<String> Saw_Code_Committed_Task_Titles;
    public static List<String> Saw_Code_UnCommitted_Task_Titles;
    public static String INTERFACE_INITIALIZATION;
    public static String HAPTIC_CONSTRAINTS_REQ;

    static {
        Saw_Code_Committed_Task_Titles = Arrays.asList("Look into Graph View.", "Redesign how view shows values.", "Discuss new design with Senior Engineer", "Develop prototype", "Show prototype to management", "Create development plan", "Create test plan", "Make changes");
        Saw_Code_UnCommitted_Task_Titles = Arrays.asList("Document how Graph View works", "Update help contents", "Review new documentation", "Publish documentation to website", "Remove old viewer", "Deploy release");
        INTERFACE_INITIALIZATION = "Interface Initialization";
        HAPTIC_CONSTRAINTS_REQ = "Haptic Constraints";
    }

    private DemoUtil() {
    }

    public static Collection<ArtifactToken> getSoftwareRequirements(boolean DEBUG, SoftwareRequirementStrs str, BranchToken branch) {
        return DemoUtil.getArtTypeRequirements(DEBUG, CoreArtifactTypes.SoftwareRequirementMsWord, str.name(), branch);
    }

    public static Collection<ArtifactToken> getArtifactsFromType(boolean DEBUG, ArtifactTypeToken artifactType, BranchToken branch) {
        if (DEBUG) {
            OseeLog.log(Activator.class, (Level)Level.INFO, (String)("Getting \"" + artifactType.getName() + "\" requirement(s) from Branch " + branch.getIdString()));
        }
        Collection arts = AtsApiService.get().getQueryService().getArtifacts(BranchId.valueOf((Long)branch.getId()), false, new ArtifactTypeToken[]{artifactType});
        if (DEBUG) {
            OseeLog.log(Activator.class, (Level)Level.INFO, (String)("Found " + arts.size() + " Artifacts"));
        }
        return arts;
    }

    public static Collection<ArtifactToken> getArtTypeRequirements(boolean DEBUG, ArtifactTypeToken artifactType, String artifactNameStr, BranchToken branch) {
        if (DEBUG) {
            OseeLog.log(Activator.class, (Level)Level.INFO, (String)("Getting \"" + artifactNameStr + "\" requirement(s) from Branch " + branch.getIdString()));
        }
        Collection arts = AtsApiService.get().getQueryService().getArtifactsFromTypeAndName(artifactType, artifactNameStr, branch, QueryOption.CONTAINS_MATCH_OPTIONS);
        if (DEBUG) {
            OseeLog.log(Activator.class, (Level)Level.INFO, (String)("Found " + arts.size() + " Artifacts"));
        }
        return arts;
    }

    public static ArtifactToken getInterfaceInitializationSoftwareRequirement(boolean DEBUG, BranchToken branch) {
        if (DEBUG) {
            OseeLog.log(Activator.class, (Level)Level.INFO, (String)("Getting \"" + INTERFACE_INITIALIZATION + "\" requirement."));
        }
        return AtsApiService.get().getQueryService().getArtifactByName(CoreArtifactTypes.SoftwareRequirementMsWord, INTERFACE_INITIALIZATION, branch);
    }

    public static Collection<IAtsActionableItem> getActionableItems(ArtifactToken ... aiTokens) {
        HashSet<IAtsActionableItem> aias = new HashSet<IAtsActionableItem>();
        ArtifactToken[] artifactTokenArray = aiTokens;
        int n = aiTokens.length;
        int n2 = 0;
        while (n2 < n) {
            ArtifactToken aiToken = artifactTokenArray[n2];
            aias.add((IAtsActionableItem)AtsApiService.get().getActionableItemService().getActionableItemById((ArtifactId)aiToken));
            ++n2;
        }
        return aias;
    }

    public static int getNumTasks() {
        return Saw_Code_Committed_Task_Titles.size() + Saw_Code_UnCommitted_Task_Titles.size();
    }

    public static Collection<IAtsActionableItem> getActionableItems(AtsApi atsApi, ArtifactToken ... aiTokens) {
        HashSet<IAtsActionableItem> aias = new HashSet<IAtsActionableItem>();
        ArtifactToken[] artifactTokenArray = aiTokens;
        int n = aiTokens.length;
        int n2 = 0;
        while (n2 < n) {
            ArtifactToken aiToken = artifactTokenArray[n2];
            aias.add((IAtsActionableItem)atsApi.getActionableItemService().getActionableItemById((ArtifactId)aiToken));
            ++n2;
        }
        return aias;
    }

    public static Result isDbPopulatedWithDemoData() {
        Collection robotArtifacts = AtsApiService.get().getQueryService().getArtifactsFromTypeAndName(CoreArtifactTypes.SoftwareRequirementMsWord, "Robot", DemoBranches.SAW_Bld_1, QueryOption.CONTAINS_MATCH_OPTIONS);
        if (robotArtifacts.size() < 6) {
            return new Result(String.format("Expected at least 6 Software Requirements with name \"Robot\" but found [%s].  Database is not be populated with demo data.", robotArtifacts.size()));
        }
        return Result.TrueResult;
    }

    public static void checkDbInitSuccess() {
        if (!DemoUtil.isDbInitSuccessful()) {
            throw new OseeStateException("DbInit must be successful to continue", new Object[0]);
        }
    }

    public static void checkDbInitAndPopulateSuccess() {
        if (!DemoUtil.isDbInitSuccessful()) {
            throw new OseeStateException("DbInit must be successful to continue", new Object[0]);
        }
        if (!DemoUtil.isPopulateDbSuccessful()) {
            throw new OseeStateException("PopulateDemoDb must be successful to continue", new Object[0]);
        }
    }

    public static boolean isDbInitSuccessful() {
        return AtsApiService.get().isOseeInfo("DbInitSuccess", "true");
    }

    public static void setDbInitSuccessful(boolean success) {
        AtsApiService.get().setOseeInfo("DbInitSuccess", String.valueOf(success));
    }

    public static boolean isPopulateDbSuccessful() {
        return AtsApiService.get().isOseeInfo("PopulateSuccessful", "true");
    }

    public static void setPopulateDbSuccessful(boolean success) {
        AtsApiService.get().setOseeInfo("PopulateSuccessful", String.valueOf(success));
    }

    public static IAtsTeamWorkflow getSawCodeCommittedWf() {
        return (IAtsTeamWorkflow)AtsApiService.get().getQueryService().getWorkItem((ArtifactId)DemoArtifactToken.SAW_Commited_Code_TeamWf);
    }

    public static IAtsTeamWorkflow getSawTestCommittedWf() {
        return (IAtsTeamWorkflow)AtsApiService.get().getQueryService().getWorkItem((ArtifactId)DemoArtifactToken.SAW_Commited_Test_TeamWf);
    }

    public static IAtsTeamWorkflow getSawReqCommittedWf() {
        return (IAtsTeamWorkflow)AtsApiService.get().getQueryService().getWorkItem((ArtifactId)DemoArtifactToken.SAW_Commited_Req_TeamWf);
    }

    public static IAtsTeamWorkflow getSawSWDesignCommittedWf() {
        return (IAtsTeamWorkflow)AtsApiService.get().getQueryService().getWorkItem((ArtifactId)DemoArtifactToken.SAW_Commited_SWDesign_TeamWf);
    }

    public static IAtsTeamWorkflow getSawCodeUnCommittedWf() {
        return (IAtsTeamWorkflow)AtsApiService.get().getQueryService().getWorkItem((ArtifactId)DemoArtifactToken.SAW_UnCommited_Code_TeamWf);
    }

    public static IAtsTeamWorkflow getSawTestUnCommittedWf() {
        return (IAtsTeamWorkflow)AtsApiService.get().getQueryService().getWorkItem((ArtifactId)DemoArtifactToken.SAW_UnCommited_Test_TeamWf);
    }

    public static IAtsTeamWorkflow getSawReqUnCommittedWf() {
        return (IAtsTeamWorkflow)AtsApiService.get().getQueryService().getWorkItem((ArtifactId)DemoArtifactToken.SAW_UnCommited_Req_TeamWf);
    }

    public static IAtsTeamWorkflow getSawSWDesignUnCommittedWf() {
        return (IAtsTeamWorkflow)AtsApiService.get().getQueryService().getWorkItem((ArtifactId)DemoArtifactToken.SAW_UnCommited_SWDesign_TeamWf);
    }

    public static IAtsTeamWorkflow getSwDesignNoBranchWf() {
        return (IAtsTeamWorkflow)AtsApiService.get().getQueryService().getWorkItem((ArtifactId)DemoArtifactToken.SAW_NoBranch_SWDesign_TeamWf);
    }

    public static IAtsTeamWorkflow getSawCodeNoBranchWf() {
        return (IAtsTeamWorkflow)AtsApiService.get().getQueryService().getWorkItem((ArtifactId)DemoArtifactToken.SAW_NoBranch_Code_TeamWf);
    }

    public static IAtsTeamWorkflow getSawTestNoBranchWf() {
        return (IAtsTeamWorkflow)AtsApiService.get().getQueryService().getWorkItem((ArtifactId)DemoArtifactToken.SAW_NoBranch_Test_TeamWf);
    }

    public static IAtsTeamWorkflow getSawReqNoBranchWf() {
        return (IAtsTeamWorkflow)AtsApiService.get().getQueryService().getWorkItem((ArtifactId)DemoArtifactToken.SAW_NoBranch_Req_TeamWf);
    }

    public static IAtsTeamWorkflow getSawSWDesignNoBranchWf() {
        return (IAtsTeamWorkflow)AtsApiService.get().getQueryService().getWorkItem((ArtifactId)DemoArtifactToken.SAW_NoBranch_SWDesign_TeamWf);
    }

    public static IAtsTeamWorkflow getButtonWDoesntWorkOnSituationPageWf() {
        return (IAtsTeamWorkflow)AtsApiService.get().getQueryService().getWorkItem((ArtifactId)DemoArtifactToken.ButtonWDoesntWorkOnSituationPage_TeamWf);
    }

    public static IAtsTeamWorkflow getCantLoadDiagramTreeWf() {
        return (IAtsTeamWorkflow)AtsApiService.get().getQueryService().getWorkItem((ArtifactId)DemoArtifactToken.CantLoadDiagramTree_TeamWf);
    }

    public static IAtsTeamWorkflow getProblemInTree_TeamWfWf() {
        return (IAtsTeamWorkflow)AtsApiService.get().getQueryService().getWorkItem((ArtifactId)DemoArtifactToken.ProblemInTree_TeamWf);
    }

    public static Collection<IAtsTeamWorkflow> getSawCommittedTeamWfs() {
        return Arrays.asList(DemoUtil.getSawTestCommittedWf(), DemoUtil.getSawReqCommittedWf(), DemoUtil.getSawCodeCommittedWf());
    }

    public static Collection<IAtsTeamWorkflow> getSawUnCommittedTeamWfs() {
        return Arrays.asList(DemoUtil.getSawTestUnCommittedWf(), DemoUtil.getSawReqUnCommittedWf(), DemoUtil.getSawCodeUnCommittedWf(), DemoUtil.getSawSWDesignUnCommittedWf());
    }

    public static String getSawAtsIdsStr() {
        if (atsIds == null) {
            atsIds = Collections.toString((String)",", AtsObjects.toAtsIds(DemoUtil.getSawCommittedTeamWfs()));
        }
        return atsIds;
    }

    public static enum SoftwareRequirementStrs {
        Robot,
        CISST,
        daVinci,
        Functional,
        Event,
        Haptic;

    }
}

