/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.config.tx;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.config.tx.AtsVersionArtifactToken;
import org.eclipse.osee.ats.api.config.tx.IAtsActionableItemArtifactToken;
import org.eclipse.osee.ats.api.config.tx.IAtsConfigTx;
import org.eclipse.osee.ats.api.config.tx.IAtsConfigTxActionableItem;
import org.eclipse.osee.ats.api.config.tx.IAtsConfigTxProgram;
import org.eclipse.osee.ats.api.config.tx.IAtsConfigTxTeamDef;
import org.eclipse.osee.ats.api.config.tx.IAtsConfigTxVersion;
import org.eclipse.osee.ats.api.config.tx.IAtsProgramArtifactToken;
import org.eclipse.osee.ats.api.config.tx.IAtsTeamDefinitionArtifactToken;
import org.eclipse.osee.ats.api.config.tx.IAtsVersionArtifactToken;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.query.NextRelease;
import org.eclipse.osee.ats.api.query.ReleasedOption;
import org.eclipse.osee.ats.api.task.create.CreateTasksDefinitionBuilder;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.core.config.tx.AtsConfigTxActionableItem;
import org.eclipse.osee.ats.core.config.tx.AtsConfigTxProgram;
import org.eclipse.osee.ats.core.config.tx.AtsConfigTxTeamDef;
import org.eclipse.osee.ats.core.config.tx.AtsConfigTxVersion;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class AtsConfigTxImpl
implements IAtsConfigTx {
    private final AtsApi atsApi;
    private final IAtsChangeSet changes;
    private final Map<String, IAtsTeamDefinition> newTeams = new HashMap<String, IAtsTeamDefinition>();
    private final Map<String, IAtsActionableItem> newAis = new HashMap<String, IAtsActionableItem>();
    private final Set<Long> usedIds = new HashSet<Long>();

    public AtsConfigTxImpl(String name, AtsApi atsApi) {
        this.atsApi = atsApi;
        this.changes = atsApi.createChangeSet(name);
    }

    public IAtsConfigTxTeamDef createTeamDef(IAtsTeamDefinition parent, IAtsTeamDefinitionArtifactToken teamDef) {
        ArtifactToken newTeam = this.atsApi.getQueryService().getArtifact((ArtifactId)teamDef);
        if (newTeam == null || newTeam.isInvalid()) {
            this.checkUsedIds((ArtifactToken)teamDef);
            newTeam = this.changes.createArtifact((ArtifactToken)teamDef);
        }
        TeamDefinition newTeamDef = this.atsApi.getTeamDefinitionService().createTeamDefinition(newTeam);
        if (parent != null) {
            this.changes.relate((Object)parent, CoreRelationTypes.DefaultHierarchical_Child, (Object)newTeamDef);
        }
        this.newTeams.put(newTeam.getName(), (IAtsTeamDefinition)newTeamDef);
        return new AtsConfigTxTeamDef((IAtsObject)newTeamDef, this.atsApi, this.changes, this);
    }

    private void checkUsedIds(ArtifactToken art) {
        if (this.usedIds.contains(art.getId())) {
            throw new OseeArgumentException("Id %s already used.  Can't create token %s", new Object[]{art.getIdString(), art.toStringWithId()});
        }
        this.usedIds.add(art.getId());
    }

    public IAtsConfigTxActionableItem createActionableItem(IAtsActionableItem parent, IAtsActionableItemArtifactToken ai) {
        ArtifactToken newAiArt = this.atsApi.getQueryService().getArtifact((ArtifactId)ai);
        if (newAiArt == null || newAiArt.isInvalid()) {
            this.checkUsedIds((ArtifactToken)ai);
            newAiArt = this.changes.createArtifact((ArtifactToken)ai);
        }
        ActionableItem newAi = this.atsApi.getActionableItemService().getActionableItemById((ArtifactId)newAiArt);
        if (parent != null) {
            this.changes.relate((Object)parent, CoreRelationTypes.DefaultHierarchical_Child, (Object)newAi);
        }
        this.newAis.put(newAiArt.getName(), (IAtsActionableItem)newAi);
        return new AtsConfigTxActionableItem((IAtsObject)newAi, this.atsApi, this.changes, this);
    }

    public IAtsConfigTxActionableItem createActionableItem(IAtsActionableItemArtifactToken actionableItem) {
        ArtifactToken newAiArt = this.atsApi.getQueryService().getArtifact((ArtifactId)actionableItem);
        if (newAiArt == null || newAiArt.isInvalid()) {
            this.checkUsedIds((ArtifactToken)actionableItem);
            newAiArt = this.changes.createArtifact((ArtifactToken)actionableItem);
        }
        ActionableItem newAi = this.atsApi.getActionableItemService().createActionableItem(newAiArt);
        this.newAis.put(newAiArt.getName(), (IAtsActionableItem)newAi);
        return new AtsConfigTxActionableItem((IAtsObject)newAi, this.atsApi, this.changes, this);
    }

    public TransactionId execute() {
        return this.changes.executeIfNeeded();
    }

    public IAtsConfigTxVersion createVersion(IAtsVersionArtifactToken versionTok, ReleasedOption released, BranchToken branch, NextRelease nextRelease, IAtsTeamDefinition teamDef) {
        this.checkUsedIds((ArtifactToken)versionTok);
        ArtifactToken verArt = this.changes.createArtifact(AtsArtifactTypes.Version, versionTok.getName(), versionTok.getId());
        this.changes.setSoleAttributeValue((ArtifactId)verArt, (AttributeTypeToken)AtsAttributeTypes.Released, (Object)(released != ReleasedOption.UnReleased ? 1 : 0));
        this.changes.setSoleAttributeValue((ArtifactId)verArt, (AttributeTypeToken)AtsAttributeTypes.NextVersion, (Object)(nextRelease == NextRelease.Next ? 1 : 0));
        if (branch != null && branch.isValid()) {
            this.changes.setSoleAttributeValue((ArtifactId)verArt, (AttributeTypeToken)AtsAttributeTypes.BaselineBranchId, (Object)branch.getIdString());
            this.changes.setSoleAttributeValue((ArtifactId)verArt, (AttributeTypeToken)AtsAttributeTypes.AllowCommitBranch, (Object)true);
            this.changes.setSoleAttributeValue((ArtifactId)verArt, (AttributeTypeToken)AtsAttributeTypes.AllowCreateBranch, (Object)true);
        }
        this.changes.relate((Object)teamDef, AtsRelationTypes.TeamDefinitionToVersion_Version, (Object)verArt);
        Version newVersion = this.atsApi.getVersionService().createVersion(verArt);
        ((TeamDefinition)teamDef).addVersion(newVersion.getId());
        return new AtsConfigTxVersion((IAtsObject)newVersion, this.atsApi, this.changes, this);
    }

    public IAtsConfigTxVersion createVersion(String name, ReleasedOption released, BranchToken branch, NextRelease nextRelease, IAtsTeamDefinition teamDef) {
        return this.createVersion(AtsVersionArtifactToken.valueOf((Long)Lib.generateArtifactIdAsInt(), (String)name), released, branch, nextRelease, teamDef);
    }

    public IAtsTeamDefinition getTeamDef(ArtifactId teamDef) {
        for (Map.Entry<String, IAtsTeamDefinition> entry : this.newTeams.entrySet()) {
            if (!entry.getValue().equals(teamDef)) continue;
            return entry.getValue();
        }
        return null;
    }

    public IAtsTeamDefinition getTeamDef(String name) {
        return this.newTeams.get(name);
    }

    public IAtsConfigTxProgram createProgram(IAtsProgramArtifactToken programTok) {
        ArtifactToken newProgramArt = this.atsApi.getQueryService().getArtifact((ArtifactId)programTok);
        if (newProgramArt == null || newProgramArt.isInvalid()) {
            this.checkUsedIds((ArtifactToken)programTok);
            newProgramArt = this.changes.createArtifact((ArtifactToken)programTok);
        }
        IAtsProgram program = this.atsApi.getProgramService().getProgramById((ArtifactId)newProgramArt);
        return new AtsConfigTxProgram((IAtsObject)program, this.atsApi, this.changes, this);
    }

    public IAtsChangeSet getChanges() {
        return this.changes;
    }

    public IAtsActionableItem getActionableItem(ArtifactId artifact) {
        for (Map.Entry<String, IAtsActionableItem> entry : this.newAis.entrySet()) {
            if (!entry.getValue().getId().equals(artifact.getId())) continue;
            return entry.getValue();
        }
        return null;
    }

    public CreateTasksDefinitionBuilder createTaskDefinitionBuilder(Long id, String name) {
        CreateTasksDefinitionBuilder txTasks = new CreateTasksDefinitionBuilder(id, name);
        return txTasks;
    }

    public IAtsConfigTxProgram createProgram(ArtifactId parent, IAtsProgramArtifactToken program) {
        IAtsConfigTxProgram txProgram = this.createProgram(program);
        this.changes.relate((Object)parent, CoreRelationTypes.DefaultHierarchical_Child, (Object)txProgram.getProgram());
        return txProgram;
    }
}

