/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.column.AtsColumnTokensDefault;
import org.eclipse.osee.ats.api.column.AtsCoreCodeColumnToken;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.column.model.AtsCoreCodeColumn;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class TaskRiskFactorsColumn
extends AtsCoreCodeColumn {
    public TaskRiskFactorsColumn(AtsApi atsApi) {
        super((AtsCoreCodeColumnToken)AtsColumnTokensDefault.TaskRiskFactorsColumn, atsApi);
    }

    @Override
    public String getText(IAtsObject atsObject) throws Exception {
        String result = "";
        if (this.atsApi.getStoreService().isDeleted(atsObject)) {
            return "<deleted>";
        }
        if (atsObject instanceof IAtsTeamWorkflow) {
            IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)atsObject;
            Collection tasks = this.atsApi.getTaskService().getTasks(teamWf);
            ArrayList<String> riskFactors = new ArrayList<String>();
            for (IAtsTask task : tasks) {
                String riskFactor = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)task, (AttributeTypeToken)AtsAttributeTypes.RiskFactor, (Object)"");
                if (!Strings.isValid((String)riskFactor) || riskFactors.contains(riskFactor)) continue;
                riskFactors.add(riskFactor);
            }
            if (riskFactors.size() > 0) {
                riskFactors.sort(Comparator.naturalOrder());
                return Collections.toString((String)", ", riskFactors);
            }
            return result;
        }
        if (atsObject instanceof IAtsTask) {
            IAtsTask task = (IAtsTask)atsObject;
            return (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)task, (AttributeTypeToken)AtsAttributeTypes.RiskFactor, (Object)"");
        }
        return result;
    }
}

