/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsColumnTokensDefault;
import org.eclipse.osee.ats.api.column.AtsCoreCodeColumnToken;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.column.model.AtsCoreCodeColumn;

public class PrIdColumn
extends AtsCoreCodeColumn {
    public PrIdColumn(AtsApi atsApi) {
        super((AtsCoreCodeColumnToken)AtsColumnTokensDefault.PrIdColumn, atsApi);
    }

    @Override
    public String getText(IAtsObject atsObject) throws Exception {
        IAtsTeamWorkflow teamWf;
        if (atsObject instanceof IAtsWorkItem && (teamWf = ((IAtsWorkItem)atsObject).getParentTeamWorkflow()) != null) {
            String atsId = teamWf.getAtsId();
            if (atsId.startsWith("PR")) {
                return teamWf.getAtsId();
            }
            for (IAtsTeamWorkflow sibling : this.atsApi.getWorkItemService().getSiblings(teamWf)) {
                String siblingId = sibling.getAtsId();
                if (!siblingId.startsWith("PR")) continue;
                return siblingId;
            }
        }
        return "";
    }
}

