/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.column.AtsColumnTokensDefault;
import org.eclipse.osee.ats.api.column.AtsCoreCodeColumnToken;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.column.model.AtsCoreCodeColumn;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public class FeatureImpactReferenceColumn
extends AtsCoreCodeColumn {
    public FeatureImpactReferenceColumn(AtsApi atsApi) {
        super((AtsCoreCodeColumnToken)AtsColumnTokensDefault.FeatureImpactReferenceColumn, atsApi);
    }

    @Override
    public String getText(IAtsObject atsObject) throws Exception {
        String result = "";
        if (this.atsApi.getStoreService().isDeleted(atsObject)) {
            return "<deleted>";
        }
        if (atsObject instanceof IAtsTeamWorkflow) {
            IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)atsObject;
            Collection featureImpactArtIds = this.atsApi.getAttributeResolver().getArtifactIdReferences(atsObject.getArtifactToken(), (AttributeTypeToken)AtsAttributeTypes.FeatureImpactReference);
            ArrayList<String> featureImpactNames = new ArrayList<String>();
            for (ArtifactId featureImpactArtId : featureImpactArtIds) {
                featureImpactNames.add(this.getFeatureImpactName(teamWf, featureImpactArtId));
            }
            return featureImpactNames.size() > 0 ? Collections.toString((String)", ", featureImpactNames) : result;
        }
        return result;
    }

    private String getFeatureImpactName(IAtsTeamWorkflow teamWf, ArtifactId featureImpactArtId) {
        IAtsTeamDefinition mainTeamDef = this.atsApi.getTeamDefinitionService().getTeamDefHoldingVersions(teamWf.getTeamDefinition());
        if (mainTeamDef != null) {
            for (IAtsVersion ver : this.atsApi.getVersionService().getVersions(mainTeamDef)) {
                BranchToken branch = this.atsApi.getBranchService().getBranch((IAtsConfigObject)ver);
                if (!branch.isValid()) continue;
                return this.atsApi.getQueryService().getArtifact(featureImpactArtId, (BranchId)branch).getName();
            }
        }
        return "Feature Not Found for " + featureImpactArtId.getId();
    }
}

