/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.agile;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileBacklog;
import org.eclipse.osee.ats.api.agile.IAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.IAgileProgram;
import org.eclipse.osee.ats.api.agile.IAgileProgramFeature;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.agile.JaxAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.JaxAgileProgramFeature;
import org.eclipse.osee.ats.api.agile.JaxAgileTeam;
import org.eclipse.osee.ats.api.agile.JaxNewAgileTeam;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionTokens;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.core.agile.AgileBacklog;
import org.eclipse.osee.ats.core.agile.AgileFeatureGroup;
import org.eclipse.osee.ats.core.agile.AgileFolders;
import org.eclipse.osee.ats.core.agile.AgileProgramFeature;
import org.eclipse.osee.ats.core.agile.AgileSprint;
import org.eclipse.osee.ats.core.agile.AgileTeam;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;

public class AgileFactory {
    private AgileFactory() {
    }

    public static IAgileTeam createAgileTeam(Log logger, AtsApi atsApi, JaxNewAgileTeam newTeam) {
        ArtifactToken userArt = atsApi.getQueryService().getArtifact((IAtsObject)atsApi.getUserService().getCurrentUser());
        ArtifactToken agileTeamArt = atsApi.getQueryService().getArtifact(newTeam.getId());
        if (agileTeamArt == null) {
            IAtsChangeSet changes = atsApi.createChangeSet("Create new Agile Team");
            agileTeamArt = changes.createArtifact(AtsArtifactTypes.AgileTeam, newTeam.getName(), newTeam.getId());
            changes.setSoleAttributeValue((ArtifactId)agileTeamArt, (AttributeTypeToken)AtsAttributeTypes.Active, (Object)true);
            ArtifactId topAgileFolder = AgileFolders.getOrCreateTopAgileFolder(atsApi, (ArtifactId)userArt, changes);
            if (Strings.isNumeric((String)newTeam.getProgramId())) {
                ArtifactToken programArt = atsApi.getQueryService().getArtifact(Long.valueOf(newTeam.getProgramId()));
                changes.addChild((ArtifactId)programArt, (ArtifactId)agileTeamArt);
            } else {
                changes.addChild(topAgileFolder, (ArtifactId)agileTeamArt);
            }
            HashSet atsTeamArts = new HashSet();
            changes.setRelations((Object)agileTeamArt, AtsRelationTypes.AgileTeamToAtsTeam_AtsTeam, atsTeamArts);
            changes.execute();
        }
        return AgileFactory.getAgileTeam(logger, atsApi, agileTeamArt);
    }

    public static IAgileTeam updateAgileTeam(Log logger, AtsApi atsApi, JaxAgileTeam team) {
        ArtifactToken userArt = atsApi.getQueryService().getArtifact((IAtsObject)atsApi.getUserService().getCurrentUser());
        IAtsChangeSet changes = atsApi.createChangeSet("Update new Agile Team");
        ArtifactToken agileTeamArt = atsApi.getQueryService().getArtifact(team.getId());
        if (agileTeamArt == null) {
            throw new OseeStateException("Agile Team not found with Id [%s]", new Object[]{team.getIdString()});
        }
        if (Strings.isValid((String)team.getName()) && !team.getName().equals(agileTeamArt.getName())) {
            changes.setName(agileTeamArt, team.getName());
        }
        if (Strings.isValid((String)team.getDescription()) && !team.getDescription().equals(atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)agileTeamArt, (AttributeTypeToken)AtsAttributeTypes.Description, (Object)""))) {
            changes.setSoleAttributeValue((ArtifactId)agileTeamArt, (AttributeTypeToken)AtsAttributeTypes.Description, (Object)team.getDescription());
        }
        changes.setSoleAttributeValue((ArtifactId)agileTeamArt, (AttributeTypeToken)AtsAttributeTypes.Active, (Object)team.isActive());
        ArtifactId topAgileFolder = AgileFolders.getOrCreateTopAgileFolder(atsApi, (ArtifactId)userArt, changes);
        if (topAgileFolder.notEqual((Id)atsApi.getRelationResolver().getParent((ArtifactId)agileTeamArt))) {
            changes.unrelateFromAll(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)agileTeamArt);
            changes.addChild(topAgileFolder, (ArtifactId)agileTeamArt);
        }
        HashSet<ArtifactToken> atsTeamArts = new HashSet<ArtifactToken>();
        Iterator iterator = team.getAtsTeamIds().iterator();
        while (iterator.hasNext()) {
            long atsTeamId = (Long)iterator.next();
            ArtifactToken atsTeamArt = atsApi.getQueryService().getArtifact(Long.valueOf(atsTeamId));
            if (atsTeamArt != null && atsTeamArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamDefinition})) {
                atsTeamArts.add(atsTeamArt);
                continue;
            }
            throw new OseeArgumentException("ID %d is not a valid Ats Team Definition", new Object[]{atsTeamId});
        }
        changes.setRelations((Object)agileTeamArt, AtsRelationTypes.AgileTeamToAtsTeam_AtsTeam, atsTeamArts);
        changes.execute();
        return AgileFactory.getAgileTeam(logger, atsApi, agileTeamArt);
    }

    public static IAgileTeam getAgileTeam(Log logger, AtsApi atsApi, Object artifact) {
        AgileTeam team = null;
        if (artifact instanceof ArtifactId) {
            ArtifactToken art = atsApi.getQueryService().getArtifact((ArtifactId)artifact);
            team = new AgileTeam(logger, atsApi, art);
        }
        return team;
    }

    public static IAgileFeatureGroup createAgileFeatureGroup(Log logger, AtsApi atsApi, long teamId, String name, String guid, Long id) {
        JaxAgileFeatureGroup feature = new JaxAgileFeatureGroup();
        feature.setName(name);
        feature.setId(id);
        feature.setTeamId(teamId);
        feature.setActive(true);
        return AgileFactory.createAgileFeatureGroup(logger, atsApi, feature);
    }

    public static IAgileProgramFeature createAgileProgramFeature(Log logger, AtsApi atsApi, long programBacklogItemId, String name, String guid, Long id) {
        JaxAgileProgramFeature feature = new JaxAgileProgramFeature();
        feature.setName(name);
        feature.setId(id);
        feature.setProgramBacklogItemId(programBacklogItemId);
        feature.setActive(true);
        return AgileFactory.createAgileProgramFeature(logger, atsApi, feature);
    }

    public static IAgileProgramFeature createAgileProgramFeature(Log logger, AtsApi atsApi, JaxAgileProgramFeature newProgramFeature) {
        IAtsChangeSet changes = atsApi.createChangeSet("Create new Agile Program Feature");
        ArtifactToken programFeature = changes.createArtifact(AtsArtifactTypes.AgileProgramFeature, newProgramFeature.getName(), newProgramFeature.getId());
        changes.setSoleAttributeValue((ArtifactId)programFeature, (AttributeTypeToken)AtsAttributeTypes.Active, (Object)newProgramFeature.isActive());
        ArtifactToken programBacklogItemArt = atsApi.getQueryService().getArtifact(Long.valueOf(newProgramFeature.getProgramBacklogItemId()));
        changes.addChild((ArtifactId)programBacklogItemArt, (ArtifactId)programFeature);
        changes.execute();
        return AgileFactory.getAgileProgramFeature(logger, atsApi, (ArtifactId)programFeature);
    }

    private static IAgileProgramFeature getAgileProgramFeature(Log logger, AtsApi atsApi, ArtifactId artifact) {
        return new AgileProgramFeature(logger, atsApi, atsApi.getQueryService().getArtifact(artifact));
    }

    public static IAgileFeatureGroup createAgileFeatureGroup(Log logger, AtsApi atsApi, JaxAgileFeatureGroup newFeatureGroup) {
        ArtifactToken userArt = atsApi.getQueryService().getArtifact((IAtsObject)atsApi.getUserService().getCurrentUser());
        IAtsChangeSet changes = atsApi.createChangeSet("Create new Agile Feature Group");
        ArtifactToken featureGroupArt = changes.createArtifact(AtsArtifactTypes.AgileFeatureGroup, newFeatureGroup.getName(), newFeatureGroup.getId());
        changes.setSoleAttributeValue((ArtifactId)featureGroupArt, (AttributeTypeToken)AtsAttributeTypes.Active, (Object)newFeatureGroup.isActive());
        ArtifactId featureGroupFolder = AgileFolders.getOrCreateTopFeatureGroupFolder(atsApi, newFeatureGroup.getTeamId(), (ArtifactId)userArt, changes);
        changes.addChild(featureGroupFolder, (ArtifactId)featureGroupArt);
        ArtifactId team = AgileFolders.getTeamFolder(atsApi, newFeatureGroup.getTeamId());
        changes.relate(team, AtsRelationTypes.AgileTeamToFeatureGroup_AgileFeatureGroup, (ArtifactId)featureGroupArt);
        changes.execute();
        return AgileFactory.getAgileFeatureGroup(logger, atsApi, (ArtifactId)featureGroupArt);
    }

    public static IAgileFeatureGroup getAgileFeatureGroup(Log logger, AtsApi atsApi, ArtifactId artifact) {
        return new AgileFeatureGroup(logger, atsApi, atsApi.getQueryService().getArtifact(artifact));
    }

    public static IAgileSprint createAgileSprint(Log logger, AtsApi atsApi, long teamId, String name, Long id) {
        IAtsChangeSet changes = atsApi.getStoreService().createAtsChangeSet("Create new Agile Sprint", AtsCoreUsers.SYSTEM_USER);
        ArtifactToken sprintArt = changes.createArtifact(AtsArtifactTypes.AgileSprint, name, id);
        IAgileSprint sprint = atsApi.getWorkItemService().getAgileSprint(sprintArt);
        atsApi.getActionService().setAtsId((IAtsObject)sprint, AtsApiService.get().getTeamDefinitionService().getTopTeamDefinition(), null, changes);
        WorkDefinition workDefinition = atsApi.getWorkDefinitionService().getWorkDefinition((Id)AtsWorkDefinitionTokens.WorkDef_Sprint);
        atsApi.getWorkDefinitionService().setWorkDefinitionAttrs((IAtsWorkItem)sprint, workDefinition, changes);
        atsApi.getActionService().initializeNewStateMachine((IAtsWorkItem)sprint, Arrays.asList(AtsCoreUsers.UNASSIGNED_USER), new Date(), atsApi.getUserService().getCurrentUser(), workDefinition, changes);
        changes.add((Object)sprintArt);
        ArtifactId teamFolder = AgileFolders.getTeamFolder(atsApi, teamId);
        ArtifactId agileSprintFolderArt = AgileFolders.getOrCreateTopSprintFolder(atsApi, teamId, changes);
        changes.relate(agileSprintFolderArt, CoreRelationTypes.DefaultHierarchical_Child, (ArtifactId)sprintArt);
        changes.relate(teamFolder, AtsRelationTypes.AgileTeamToSprint_Sprint, (ArtifactId)sprintArt);
        changes.execute();
        return AgileFactory.getAgileSprint(logger, atsApi, (ArtifactId)sprintArt);
    }

    public static IAgileSprint getAgileSprint(Log logger, AtsApi atsApi, ArtifactId artifact) {
        ArtifactToken artifact2 = atsApi.getQueryService().getArtifact(artifact);
        return new AgileSprint(logger, atsApi, artifact2);
    }

    public static IAgileBacklog createAgileBacklog(Log logger, AtsApi atsApi, long teamId, String name, Long id) {
        IAtsChangeSet changes = atsApi.getStoreService().createAtsChangeSet("Create new Agile Backlog", AtsCoreUsers.SYSTEM_USER);
        ArtifactToken backlogArt = changes.createArtifact(AtsArtifactTypes.AgileBacklog, name, id);
        IAgileBacklog backlog = atsApi.getWorkItemService().getAgileBacklog(backlogArt);
        atsApi.getActionService().setAtsId((IAtsObject)backlog, AtsApiService.get().getTeamDefinitionService().getTopTeamDefinition(), null, changes);
        WorkDefinition workDefinition = atsApi.getWorkDefinitionService().getWorkDefinition((Id)AtsWorkDefinitionTokens.WorkDef_Goal);
        atsApi.getWorkDefinitionService().setWorkDefinitionAttrs((IAtsWorkItem)backlog, workDefinition, changes);
        atsApi.getActionService().initializeNewStateMachine((IAtsWorkItem)backlog, Arrays.asList(AtsCoreUsers.UNASSIGNED_USER), new Date(), atsApi.getUserService().getCurrentUser(), workDefinition, changes);
        changes.add((Object)backlogArt);
        ArtifactId teamFolder = AgileFolders.getTeamFolder(atsApi, teamId);
        changes.relate(teamFolder, AtsRelationTypes.AgileTeamToBacklog_Backlog, (ArtifactId)backlogArt);
        changes.relate(teamFolder, CoreRelationTypes.DefaultHierarchical_Child, (ArtifactId)backlogArt);
        changes.execute();
        return AgileFactory.getAgileBacklog(logger, atsApi, backlogArt);
    }

    public static IAgileBacklog getAgileBacklog(Log logger, AtsApi atsApi, Object artifact) {
        return new AgileBacklog(logger, atsApi, (ArtifactToken)artifact);
    }

    public static IAgileProgram getAgileProgram(ArtifactId progArt) {
        return null;
    }

    public static JaxAgileTeam createJaxTeam(IAgileTeam agileTeam) {
        JaxAgileTeam created = new JaxAgileTeam();
        if (agileTeam == null) {
            throw new RuntimeException("In AgileFactory.createJaxTeam, the parameter \"agileTeam\" is null which is dereferenced");
        }
        created.setName(agileTeam.getName());
        created.setId(agileTeam.getId());
        created.setActive(agileTeam.isActive());
        created.getAtsTeamIds().addAll(agileTeam.getAtsTeamIds());
        if (agileTeam.getBacklogId() != null) {
            created.setBacklogId(ArtifactId.valueOf((Long)agileTeam.getBacklogId().getId()));
        }
        created.setSprintId(agileTeam.getSprintId());
        created.setDescription(agileTeam.getDescription());
        return created;
    }

    public static JaxAgileFeatureGroup createJaxAgileFeatureGroup(IAgileFeatureGroup agileFeatureGroup) {
        JaxAgileFeatureGroup newGroup = new JaxAgileFeatureGroup();
        newGroup.setName(agileFeatureGroup.getName());
        newGroup.setId(agileFeatureGroup.getId());
        newGroup.setActive(agileFeatureGroup.isActive());
        newGroup.setTeamId(agileFeatureGroup.getTeamId());
        return newGroup;
    }
}

