/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.annotation.Swagger;
import org.eclipse.osee.testscript.ScriptApi;
import org.eclipse.osee.testscript.ScriptBatchEndpoint;
import org.eclipse.osee.testscript.ScriptDefEndpoint;
import org.eclipse.osee.testscript.ScriptDownloadEndpoint;
import org.eclipse.osee.testscript.ScriptImportEndpoint;
import org.eclipse.osee.testscript.ScriptResultEndpoint;
import org.eclipse.osee.testscript.ScriptSetDiffEndpoint;
import org.eclipse.osee.testscript.ScriptSetEndpoint;
import org.eclipse.osee.testscript.TestCaseEndpoint;
import org.eclipse.osee.testscript.TestPointEndpoint;
import org.eclipse.osee.testscript.TmoEndpoint;
import org.eclipse.osee.testscript.internal.ScriptBatchEndpointImpl;
import org.eclipse.osee.testscript.internal.ScriptDefEndpointImpl;
import org.eclipse.osee.testscript.internal.ScriptDownloadEndpointImpl;
import org.eclipse.osee.testscript.internal.ScriptImportEndpointImpl;
import org.eclipse.osee.testscript.internal.ScriptResultEndpointImpl;
import org.eclipse.osee.testscript.internal.ScriptSetDiffEndpointImpl;
import org.eclipse.osee.testscript.internal.ScriptSetEndpointImpl;
import org.eclipse.osee.testscript.internal.TestCaseEndpointImpl;
import org.eclipse.osee.testscript.internal.TestPointEndpointImpl;

@Path(value="tmo")
@Swagger
public class TmoEndpointImpl
implements TmoEndpoint {
    private final ScriptApi testScriptApi;

    public TmoEndpointImpl(ScriptApi testScriptApi) {
        this.testScriptApi = testScriptApi;
    }

    @Override
    @Path(value="{branch}/set")
    @Produces(value={"application/json"})
    public ScriptSetEndpoint getScriptSetTypes(@PathParam(value="branch") BranchId branch) {
        return new ScriptSetEndpointImpl(branch, this.testScriptApi.getScriptProgramApi());
    }

    @Override
    @Path(value="{branch}/batch")
    @Produces(value={"application/json"})
    public ScriptBatchEndpoint getScriptBatchEndpoint(@PathParam(value="branch") BranchId branch) {
        return new ScriptBatchEndpointImpl(branch, this.testScriptApi.getScriptBatchApi());
    }

    @Override
    @Path(value="{branch}/def")
    @Produces(value={"application/json"})
    public ScriptDefEndpoint getScriptDefinitionTypes(@PathParam(value="branch") BranchId branch) {
        return new ScriptDefEndpointImpl(branch, this.testScriptApi.getScriptDefApi());
    }

    @Override
    @Path(value="{branch}/result")
    @Produces(value={"application/json"})
    public ScriptResultEndpoint getScriptResultTypes(@PathParam(value="branch") BranchId branch) {
        return new ScriptResultEndpointImpl(branch, this.testScriptApi.getScriptResultApi());
    }

    @Override
    @Path(value="{branch}/case")
    @Produces(value={"application/json"})
    public TestCaseEndpoint getTestCaseTypes(@PathParam(value="branch") BranchId branch) {
        return new TestCaseEndpointImpl(branch, this.testScriptApi.getTestCaseApi());
    }

    @Override
    @Path(value="{branch}/point")
    @Produces(value={"application/json"})
    public TestPointEndpoint getTestPointTypes(@PathParam(value="branch") BranchId branch) {
        return new TestPointEndpointImpl(branch, this.testScriptApi.getTestPointApi());
    }

    @Override
    @Path(value="{branch}/import")
    @Produces(value={"application/json"})
    public ScriptImportEndpoint getTmoImportEndpoint(@PathParam(value="branch") BranchId branch) {
        return new ScriptImportEndpointImpl(branch, this.testScriptApi.getTmoImportApi());
    }

    @Override
    @Path(value="{branch}/download")
    @Produces(value={"application/json"})
    public ScriptDownloadEndpoint getTmoDownloadEndpoint(@PathParam(value="branch") BranchId branch) {
        return new ScriptDownloadEndpointImpl(branch, this.testScriptApi);
    }

    @Override
    @Path(value="{branch}/diff")
    @Produces(value={"application/json"})
    public ScriptSetDiffEndpoint getScriptSetDiffEndpoint(@PathParam(value="branch") BranchId branch) {
        return new ScriptSetDiffEndpointImpl(branch, this.testScriptApi.getScriptResultApi());
    }
}

