/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithoutGammas;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.rest.model.transaction.Attribute;
import org.eclipse.osee.orcs.rest.model.transaction.CreateArtifact;

public class StackTraceToken
extends ArtifactAccessorResultWithoutGammas {
    public static final StackTraceToken SENTINEL = new StackTraceToken();
    private String source;
    private String line;

    public StackTraceToken(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public StackTraceToken(ArtifactReadable art) {
        super(art);
        this.setId(art.getId());
        this.setName(art.getName());
        this.setSource(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.StackTraceSource, ""));
        this.setLine(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.StackTraceLine, ""));
    }

    public StackTraceToken(Long id, String name) {
        super(id, name);
        this.setSource("");
        this.setLine("");
    }

    public StackTraceToken() {
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getLine() {
        return this.line;
    }

    public void setLine(String line) {
        this.line = line;
    }

    public CreateArtifact createArtifact(String key) {
        HashMap<Object, String> values = new HashMap<Object, String>();
        values.put(CoreAttributeTypes.StackTraceSource, this.getSource());
        values.put(CoreAttributeTypes.StackTraceLine, this.getLine());
        CreateArtifact art = new CreateArtifact();
        art.setName(this.getName());
        art.setTypeId(CoreArtifactTypes.StackTrace.getIdString());
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        for (AttributeTypeToken type : CoreArtifactTypes.StackTrace.getValidAttributeTypes()) {
            String value = (String)values.get(type);
            if (Strings.isInValid((String)value)) continue;
            Attribute attr = new Attribute(type.getIdString());
            attr.setValue(Arrays.asList(value));
            attrs.add(attr);
        }
        art.setAttributes(attrs);
        art.setkey(key);
        return art;
    }
}

