/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.testscript.ScriptResultApi;
import org.eclipse.osee.testscript.ScriptSetDiffEndpoint;
import org.eclipse.osee.testscript.internal.ScriptResultToken;
import org.eclipse.osee.testscript.internal.SetDiffToken;

public class ScriptSetDiffEndpointImpl
implements ScriptSetDiffEndpoint {
    private final ScriptResultApi resultApi;
    private final BranchId branch;

    public ScriptSetDiffEndpointImpl(BranchId branch, ScriptResultApi resultApi) {
        this.resultApi = resultApi;
        this.branch = branch;
    }

    @Override
    public Collection<SetDiffToken> getSetDiffs(ArtifactId viewId, List<ArtifactId> ciSets) {
        LinkedList<SetDiffToken> results = new LinkedList<SetDiffToken>();
        if (ciSets == null || ciSets.isEmpty()) {
            return results;
        }
        HashMap<String, SetDiffToken> diffs = new HashMap<String, SetDiffToken>();
        for (ArtifactId setId : ciSets) {
            Collection<ScriptResultToken> setResults = this.resultApi.getAllForSet(this.branch, viewId, setId);
            for (ScriptResultToken result : setResults) {
                SetDiffToken diff = diffs.getOrDefault(result.getName(), new SetDiffToken(result.getName(), ciSets.size()));
                diff.addResult(setId, result);
                diffs.put(result.getName(), diff);
            }
        }
        LinkedList<SetDiffToken> sortedDiffs = new LinkedList<SetDiffToken>(diffs.values());
        Collections.sort(sortedDiffs, new Comparator<SetDiffToken>(){

            @Override
            public int compare(SetDiffToken o1, SetDiffToken o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return sortedDiffs;
    }
}

