/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import java.io.File;
import javax.ws.rs.core.Response;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.testscript.ScriptApi;
import org.eclipse.osee.testscript.ScriptDownloadEndpoint;
import org.eclipse.osee.testscript.internal.ScriptBatchStreamingOutput;
import org.eclipse.osee.testscript.internal.ScriptBatchToken;
import org.eclipse.osee.testscript.internal.ScriptResultToken;
import org.eclipse.osee.testscript.internal.TmoFileStreamingOutput;

public class ScriptDownloadEndpointImpl
implements ScriptDownloadEndpoint {
    private final BranchId branch;
    private final ScriptApi scriptApi;

    public ScriptDownloadEndpointImpl(BranchId branch, ScriptApi scriptApi) {
        this.branch = branch;
        this.scriptApi = scriptApi;
    }

    @Override
    public Response downloadTmo(ArtifactId resultId) {
        ScriptResultToken result = this.scriptApi.getScriptResultApi().get(this.branch, resultId);
        if (result.isInvalid()) {
            return Response.status((int)406, (String)"Result artifact not found").build();
        }
        File tmoFile = new File(result.getFileUrl());
        if (!tmoFile.exists()) {
            return Response.status((int)406, (String)"TMO file not found").build();
        }
        return Response.ok((Object)new TmoFileStreamingOutput(tmoFile)).build();
    }

    @Override
    public Response downloadBatch(ArtifactId batchId) {
        ScriptBatchToken batch = this.scriptApi.getScriptBatchApi().get(this.branch, batchId);
        if (batch.isInvalid()) {
            return Response.status((int)406, (String)"Batch artifact not found").build();
        }
        File batchFolder = new File(batch.getFolderUrl());
        if (!batchFolder.exists()) {
            return Response.status((int)406, (String)"Batch files not found").build();
        }
        return Response.ok((Object)new ScriptBatchStreamingOutput(batchFolder.listFiles(), batch)).build();
    }
}

