/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.util.SortOrder;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.testscript.ScriptBatchApi;
import org.eclipse.osee.testscript.ScriptBatchEndpoint;
import org.eclipse.osee.testscript.internal.ScriptBatchToken;

public class ScriptBatchEndpointImpl
implements ScriptBatchEndpoint {
    private final ScriptBatchApi scriptBatchApi;
    private final BranchId branch;

    public ScriptBatchEndpointImpl(BranchId branch, ScriptBatchApi scriptBatchApi) {
        this.scriptBatchApi = scriptBatchApi;
        this.branch = branch;
    }

    @Override
    public Collection<ScriptBatchToken> getAll(String filter, ArtifactId viewId, long pageNum, long pageSize) {
        ArtifactId artifactId = viewId = viewId == null ? ArtifactId.SENTINEL : viewId;
        if (Strings.isValid((String)filter)) {
            return this.scriptBatchApi.getAllByFilter(this.branch, viewId, filter, pageNum, pageSize, (AttributeTypeId)CoreAttributeTypes.ExecutionDate);
        }
        return this.scriptBatchApi.getAll(this.branch, viewId, pageNum, pageSize, (AttributeTypeId)CoreAttributeTypes.ExecutionDate);
    }

    @Override
    public Collection<ScriptBatchToken> getAllForSet(ArtifactId setId, String filter, ArtifactId viewId, long pageNum, long pageSize) {
        viewId = viewId == null ? ArtifactId.SENTINEL : viewId;
        return this.scriptBatchApi.getAllFromScriptSet(this.branch, setId, viewId, filter, pageNum, pageSize, (AttributeTypeId)CoreAttributeTypes.ExecutionDate, SortOrder.DESCENDING);
    }

    @Override
    public int getAllForSetCount(ArtifactId setId, String filter, ArtifactId viewId) {
        viewId = viewId == null ? ArtifactId.SENTINEL : viewId;
        return this.scriptBatchApi.getAllFromScriptSetCount(this.branch, setId, viewId, filter);
    }

    @Override
    public ScriptBatchToken getBatch(ArtifactId batchId) {
        return this.scriptBatchApi.get(this.branch, batchId);
    }

    @Override
    public int getCount(String filter, ArtifactId viewId) {
        return this.scriptBatchApi.getCountWithFilter(this.branch, viewId, filter);
    }
}

