/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.authorization.admin;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.authorization.admin.AuthorizationConfiguration;
import org.eclipse.osee.authorization.admin.AuthorizationConstants;
import org.eclipse.osee.authorization.admin.AuthorizationOverride;
import org.eclipse.osee.authorization.admin.internal.AuthorizationUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AuthorizationConfigurationBuilder {
    private final AuthorizationConfigurationImpl config = new AuthorizationConfigurationImpl();

    private AuthorizationConfigurationBuilder() {
    }

    public static AuthorizationConfigurationBuilder newBuilder() {
        return new AuthorizationConfigurationBuilder();
    }

    public AuthorizationConfiguration build() {
        return this.config.clone();
    }

    public AuthorizationConfigurationBuilder properties(Map<String, Object> props) {
        this.config.loadProperties(props);
        return this;
    }

    public AuthorizationConfigurationBuilder override(AuthorizationOverride override) {
        this.config.setOverride(override);
        return this;
    }

    public AuthorizationConfigurationBuilder scheme(String scheme) {
        this.config.addScheme(scheme);
        return this;
    }

    private static final class AuthorizationConfigurationImpl
    implements AuthorizationConfiguration,
    Cloneable {
        private AuthorizationOverride override;
        private final Set<String> schemes = new HashSet<String>();
        private String defaultScheme;

        private AuthorizationConfigurationImpl() {
        }

        public synchronized AuthorizationConfigurationImpl clone() {
            AuthorizationConfigurationImpl cloned = new AuthorizationConfigurationImpl();
            cloned.override = this.override;
            cloned.addSchemes(this.schemes);
            return cloned;
        }

        public void setOverride(AuthorizationOverride override) {
            this.override = override;
        }

        @Override
        public AuthorizationOverride getOverride() {
            return this.override;
        }

        @Override
        public boolean hasOverride() {
            return this.override != null && AuthorizationOverride.NONE != this.override;
        }

        @Override
        public Iterable<String> getAllowedSchemes() {
            return AuthorizationUtil.unmodifiableSortedIterable(this.schemes);
        }

        @Override
        public String getDefaultScheme() {
            return this.defaultScheme;
        }

        public void addSchemes(Collection<String> toAdd) {
            if (toAdd != null && !toAdd.isEmpty()) {
                for (String scheme : toAdd) {
                    this.addScheme(scheme);
                }
            }
        }

        public void addScheme(String scheme) {
            if (Strings.isValid((String)scheme)) {
                this.schemes.add(AuthorizationUtil.normalize(scheme));
            }
        }

        public void setDefaultScheme(String scheme) {
            if (Strings.isValid((String)scheme)) {
                this.defaultScheme = scheme;
            }
        }

        public void loadProperties(Map<String, Object> props) {
            if (props != null && !props.isEmpty()) {
                this.setOverride(this.getOverrideType(props, AuthorizationConstants.AUTHORIZATION_OVERRIDE, AuthorizationConstants.DEFAULT_AUTHORIZATION_OVERRIDE));
                this.addSchemes(this.getSet(props, AuthorizationConstants.AUTHORIZATION_SCHEME_ALLOWED, "None"));
                this.setDefaultScheme(this.get(props, AuthorizationConstants.AUTHORIZATION_SCHEME_DEFAULT, ""));
            }
        }

        private AuthorizationOverride getOverrideType(Map<String, Object> props, String key, AuthorizationOverride defaultValue) {
            String toReturn = this.get(props, key, defaultValue);
            return AuthorizationOverride.parse(toReturn);
        }

        private Collection<String> getSet(Map<String, Object> props, String key, String defaultValue) {
            HashSet<String> toReturn = new HashSet<String>();
            String joinedArray = this.get(props, key, "");
            if (Strings.isValid((String)joinedArray)) {
                String[] split;
                String[] stringArray = split = joinedArray.split(",");
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    String toAdd = AuthorizationUtil.normalize(value);
                    if (Strings.isValid((String)toAdd)) {
                        toReturn.add(toAdd);
                    }
                    ++n2;
                }
            } else {
                toReturn.add(defaultValue);
            }
            return toReturn;
        }

        private String get(Map<String, Object> props, String key, Enum<?> defaultValue) {
            return this.get(props, key, defaultValue != null ? defaultValue.name() : null);
        }

        private String get(Map<String, Object> props, String key, String defaultValue) {
            String toReturn = defaultValue;
            Object object = props.get(key);
            if (object != null) {
                toReturn = String.valueOf(object);
            }
            return toReturn;
        }
    }
}

