/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.ecj;

import java.util.Map;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.scout.sdk.core.java.ecj.AbstractJavaElementWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.BindingAnnotationWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.SpiWithEcjUtils;
import org.eclipse.scout.sdk.core.java.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.java.model.api.internal.AnnotationImplementor;
import org.eclipse.scout.sdk.core.java.model.spi.AbstractJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.spi.AnnotatableSpi;
import org.eclipse.scout.sdk.core.java.model.spi.AnnotationElementSpi;
import org.eclipse.scout.sdk.core.java.model.spi.AnnotationSpi;
import org.eclipse.scout.sdk.core.java.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.java.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SourceRange;

public class DeclarationAnnotationWithEcj
extends AbstractJavaElementWithEcj<IAnnotation>
implements AnnotationSpi {
    private final AnnotatableSpi m_owner;
    private final Annotation m_astNode;
    private final FinalValue<Map<String, AnnotationElementSpi>> m_values;
    private final FinalValue<TypeSpi> m_type;
    private final FinalValue<SourceRange> m_source;

    protected DeclarationAnnotationWithEcj(AbstractJavaEnvironment env, AnnotatableSpi owner, Annotation astNode) {
        super(env);
        this.m_astNode = (Annotation)Ensure.notNull((Object)astNode);
        this.m_owner = (AnnotatableSpi)Ensure.notNull((Object)owner);
        this.m_values = new FinalValue();
        this.m_type = new FinalValue();
        this.m_source = new FinalValue();
    }

    public AnnotationSpi internalFindNewElement() {
        return SpiWithEcjUtils.findNewAnnotationIn(this.getOwner(), this.getElementName());
    }

    protected IAnnotation internalCreateApi() {
        return new AnnotationImplementor((AnnotationSpi)this);
    }

    public Annotation getInternalAstNode() {
        return this.m_astNode;
    }

    protected static TypeBinding getAnnotationTypeBinding(DeclarationAnnotationWithEcj a) {
        return a.m_astNode.type.resolveType(SpiWithEcjUtils.classScopeOf((JavaElementSpi)a.getOwner()));
    }

    public TypeSpi getType() {
        return (TypeSpi)this.m_type.computeIfAbsentAndGet(() -> SpiWithEcjUtils.bindingToType(this.javaEnvWithEcj(), DeclarationAnnotationWithEcj.getAnnotationTypeBinding(this), () -> (TypeBinding)this.withNewElement(DeclarationAnnotationWithEcj::getAnnotationTypeBinding)));
    }

    public Map<String, AnnotationElementSpi> getValues() {
        return (Map)this.m_values.computeIfAbsentAndGet(() -> BindingAnnotationWithEcj.buildAnnotationElementMap(this.m_astNode, this, this.javaEnvWithEcj()));
    }

    public AnnotatableSpi getOwner() {
        return this.m_owner;
    }

    public String getElementName() {
        return this.getType().getElementName();
    }

    Annotation annotationDeclaration() {
        return this.m_astNode;
    }

    public SourceRange getSource() {
        return (SourceRange)this.m_source.computeIfAbsentAndGet(() -> {
            CompilationUnitSpi cu = SpiWithEcjUtils.declaringTypeOf(this).getCompilationUnit();
            Annotation decl = this.m_astNode;
            return this.javaEnvWithEcj().getSource(cu, decl.sourceStart, decl.declarationSourceEnd);
        });
    }
}

