/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.refactoring.dependencyset;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.refactoring.dependencyset.MavenDependencySetWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;

public class DependencySetAction
implements IActionDelegate {
    public static final String ID = "org.eclipse.m2e.refactoring.DependencySet";
    private IFile file;
    private List<ArtifactKey> keys;

    public void run(IAction action) {
        if (this.keys != null && this.keys.size() > 0 && this.file != null) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MavenDependencySetWizard wizard = new MavenDependencySetWizard(this.file, this.keys);
            try {
                String titleForFailedChecks = "";
                RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
                op.run(shell, titleForFailedChecks);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.file = null;
        this.keys = new ArrayList<ArtifactKey>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selected = objectArray[n2];
                if (selected instanceof DependencyNode) {
                    DependencyNode node = (DependencyNode)selected;
                    this.file = this.getFileFromEditor();
                    if (node.getData().get("LEVEL") == null) {
                        Artifact artifact = node.getDependency().getArtifact();
                        this.keys.add(new ArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), null));
                    }
                }
                ++n2;
            }
        }
        if (this.keys.size() > 0 && this.file != null) {
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }

    private IFile getFileFromEditor() {
        IFile iFile;
        IEditorInput iEditorInput;
        IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (part != null && (iEditorInput = part.getEditorInput()) instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)iEditorInput;
            iFile = input.getFile();
        } else {
            iFile = null;
        }
        return iFile;
    }
}

