/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.generator.type;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.java.apidef.ApiFunction;
import org.eclipse.scout.sdk.core.java.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.java.builder.IJavaBuilderContext;
import org.eclipse.scout.sdk.core.java.builder.IJavaSourceBuilder;
import org.eclipse.scout.sdk.core.java.builder.JavaBuilderContextFunction;
import org.eclipse.scout.sdk.core.java.builder.body.IMethodBodyBuilder;
import org.eclipse.scout.sdk.core.java.builder.comment.IJavaElementCommentBuilder;
import org.eclipse.scout.sdk.core.java.builder.comment.JavaElementCommentBuilder;
import org.eclipse.scout.sdk.core.java.builder.member.IMemberBuilder;
import org.eclipse.scout.sdk.core.java.builder.member.MemberBuilder;
import org.eclipse.scout.sdk.core.java.generator.IJavaElementGenerator;
import org.eclipse.scout.sdk.core.java.generator.compilationunit.ICompilationUnitGenerator;
import org.eclipse.scout.sdk.core.java.generator.field.IFieldGenerator;
import org.eclipse.scout.sdk.core.java.generator.member.AbstractMemberGenerator;
import org.eclipse.scout.sdk.core.java.generator.member.IMemberGenerator;
import org.eclipse.scout.sdk.core.java.generator.method.IMethodGenerator;
import org.eclipse.scout.sdk.core.java.generator.method.MethodOverrideGenerator;
import org.eclipse.scout.sdk.core.java.generator.methodparam.IMethodParameterGenerator;
import org.eclipse.scout.sdk.core.java.generator.methodparam.MethodParameterGenerator;
import org.eclipse.scout.sdk.core.java.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.java.generator.type.PrimaryTypeGenerator;
import org.eclipse.scout.sdk.core.java.generator.type.SortedMemberEntry;
import org.eclipse.scout.sdk.core.java.generator.typeparam.ITypeParameterGenerator;
import org.eclipse.scout.sdk.core.java.imports.EnclosingTypeScopedImportCollector;
import org.eclipse.scout.sdk.core.java.imports.IImportCollector;
import org.eclipse.scout.sdk.core.java.imports.IImportValidator;
import org.eclipse.scout.sdk.core.java.model.api.Flags;
import org.eclipse.scout.sdk.core.java.model.api.ICompilationUnit;
import org.eclipse.scout.sdk.core.java.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.java.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.api.IMethod;
import org.eclipse.scout.sdk.core.java.model.api.IMethodParameter;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.java.transformer.IWorkingCopyTransformer;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.Strings;

public class TypeGenerator<TYPE extends ITypeGenerator<TYPE>>
extends AbstractMemberGenerator<TYPE>
implements ITypeGenerator<TYPE> {
    private static final AtomicLong HIERARCHY_TYPE_COUNTER = new AtomicLong();
    private static final String HIERARCHY_TYPE_KEY = "tmpHierarchyType";
    private final List<ITypeParameterGenerator<?>> m_typeParameters;
    private final List<JavaBuilderContextFunction<String>> m_interfaces;
    private final List<SortedMemberEntry> m_members;
    private final FinalValue<String> m_fullyQualifiedName;
    private final FinalValue<String> m_qualifier;
    private JavaBuilderContextFunction<String> m_superClass;
    private String m_declaringFullyQualifiedName;
    private boolean m_addAllNecessaryMethods;
    private IWorkingCopyTransformer m_unimplementedMethodsTransformer;
    private Function<IMethodGenerator<?, ?>, Object[]> m_unimplementedMethodSortOrderProvider;

    protected TypeGenerator() {
        this.m_typeParameters = new ArrayList();
        this.m_interfaces = new ArrayList<JavaBuilderContextFunction<String>>();
        this.m_members = new ArrayList<SortedMemberEntry>();
        this.m_fullyQualifiedName = new FinalValue();
        this.m_qualifier = new FinalValue();
    }

    protected TypeGenerator(IType type, IWorkingCopyTransformer transformer) {
        super(type, transformer);
        this.m_fullyQualifiedName = new FinalValue();
        this.m_qualifier = new FinalValue();
        this.m_typeParameters = type.typeParameters().map(p -> IWorkingCopyTransformer.transformTypeParameter(p, transformer)).flatMap(Optional::stream).collect(Collectors.toList());
        this.m_superClass = type.superClass().map(IType::reference).map(JavaBuilderContextFunction::create).orElse(null);
        this.m_interfaces = type.superInterfaces().map(IType::reference).map(JavaBuilderContextFunction::create).collect(Collectors.toList());
        this.m_members = new ArrayList<SortedMemberEntry>();
        type.fields().stream().map(f -> IWorkingCopyTransformer.transformField(f, transformer).map(g -> new SortedMemberEntry((IMemberGenerator<?>)g, (IJavaElement)f))).flatMap(Optional::stream).peek(s -> TypeGenerator.applyConnection(s.generator(), this)).collect(Collectors.toCollection(() -> this.m_members));
        type.methods().stream().map(m -> IWorkingCopyTransformer.transformMethod(m, transformer).map(g -> new SortedMemberEntry((IMemberGenerator<?>)g, (IJavaElement)m))).flatMap(Optional::stream).peek(s -> TypeGenerator.applyConnection(s.generator(), this)).collect(Collectors.toCollection(() -> this.m_members));
        type.innerTypes().stream().map(t -> IWorkingCopyTransformer.transformType(t, transformer).map(g -> new SortedMemberEntry((IMemberGenerator<?>)g, (IJavaElement)t))).flatMap(Optional::stream).peek(s -> TypeGenerator.applyConnection(s.generator(), this)).collect(Collectors.toCollection(() -> this.m_members));
        String declaringFqn = type.declaringType().map(IType::name).orElseGet(() -> type.compilationUnit().map(ICompilationUnit::containingPackage).flatMap(pck -> Strings.notBlank((CharSequence)pck.elementName())).orElse(""));
        this.setDeclaringFullyQualifiedName(declaringFqn);
    }

    public static ITypeGenerator<?> create() {
        return new TypeGenerator();
    }

    public static ITypeGenerator<?> create(IType type, IWorkingCopyTransformer transformer) {
        return new TypeGenerator(type, transformer).setDeclaringFullyQualifiedName(type.qualifier());
    }

    @Override
    protected IJavaElementCommentBuilder<?> createCommentBuilder(ISourceBuilder<?> builder) {
        return JavaElementCommentBuilder.createForType(builder, this);
    }

    @Override
    protected void build(IJavaSourceBuilder<?> builder) {
        super.build(builder);
        IImportValidator currentValidator = builder.context().validator();
        try {
            currentValidator.runWithImportCollector(() -> this.buildType(builder), inner -> new EnclosingTypeScopedImportCollector((IImportCollector)inner, this));
        }
        finally {
            builder.context().properties().setProperty(HIERARCHY_TYPE_KEY, null);
        }
    }

    protected void buildType(IJavaSourceBuilder<?> builder) {
        this.buildTypeDeclaration(MemberBuilder.create(builder));
        ((IJavaSourceBuilder)builder.space()).blockStart().nl();
        this.buildTypeBody(builder);
        ((IJavaSourceBuilder)builder.nl()).blockEnd();
    }

    protected void buildTypeDeclaration(IMemberBuilder<?> builder) {
        int flags = this.flags();
        boolean isInterface = Flags.isInterface(flags);
        builder.appendFlags(flags);
        if (Flags.isAnnotation(flags)) {
            ((IMemberBuilder)builder.at()).append("interface ");
        } else if (Flags.isEnum(flags)) {
            builder.append("enum ");
        } else if (isInterface) {
            builder.append("interface ");
        } else {
            builder.append("class ");
        }
        builder.append(this.elementName(builder.context()).orElseThrow(() -> Ensure.newFail((CharSequence)"Type must have a name.", (Object[])new Object[0])));
        builder.append(this.typeParameters(), "<", ", ", ">");
        if (!isInterface) {
            this.superClassFunc().map(af -> (String)af.apply(builder.context())).filter(sup -> !Object.class.getName().equals(sup)).ifPresent(sup -> ((IMemberBuilder)builder.append(" extends ")).ref((CharSequence)sup));
        }
        Stream<String> ifcReferences = this.interfacesFunc().map(af -> (String)af.apply(builder.context())).distinct();
        String prefix = " " + (isInterface ? "extends" : "implements") + " ";
        builder.references(ifcReferences, prefix, ", ", null);
    }

    protected void buildTypeBody(IJavaSourceBuilder<?> builder) {
        if (Flags.isInterface(this.flags())) {
            this.methods().forEach(m -> ((IMethodGenerator)m.withFlags(512)).withoutFlags(1));
        }
        builder.append(Stream.concat(this.m_members.stream(), this.buildUnimplementedMethods(builder.context())).sorted().map(SortedMemberEntry::generator), null, builder.context().lineDelimiter(), null);
    }

    protected Stream<SortedMemberEntry> buildUnimplementedMethods(IJavaBuilderContext context) {
        if (!this.isWithAllMethodsImplemented()) {
            return Stream.empty();
        }
        Function orderFunction = Objects.requireNonNullElseGet(this.m_unimplementedMethodSortOrderProvider, () -> g -> null);
        return UnimplementedMethodGenerator.create(this, context, this.m_unimplementedMethodsTransformer).map(g -> new SortedMemberEntry((IMemberGenerator<?>)g, (Object[])orderFunction.apply(g)));
    }

    @Override
    public TYPE asInterface() {
        return (TYPE)((ITypeGenerator)this.withFlags(512));
    }

    @Override
    public TYPE asAbstract() {
        return (TYPE)((ITypeGenerator)this.withFlags(1024));
    }

    @Override
    public TYPE asAnnotationType() {
        return (TYPE)((ITypeGenerator)this.withFlags(8192));
    }

    @Override
    public TYPE asEnum() {
        return (TYPE)((ITypeGenerator)this.withFlags(16384));
    }

    @Override
    public Stream<String> interfaces() {
        return this.interfacesFunc().map(JavaBuilderContextFunction::apply).flatMap(Optional::stream);
    }

    @Override
    public Stream<JavaBuilderContextFunction<String>> interfacesFunc() {
        return this.m_interfaces.stream();
    }

    @Override
    public TYPE withInterface(String interfaceReference) {
        if (Strings.hasText((CharSequence)interfaceReference)) {
            this.m_interfaces.add(JavaBuilderContextFunction.create(interfaceReference));
        }
        return (TYPE)((ITypeGenerator)this.thisInstance());
    }

    @Override
    public <A extends IApiSpecification> TYPE withInterfaceFrom(Class<A> apiDefinition, Function<A, String> interfaceSupplier) {
        if (interfaceSupplier != null) {
            this.m_interfaces.add(new ApiFunction<A, String>(apiDefinition, interfaceSupplier));
        }
        return (TYPE)((ITypeGenerator)this.thisInstance());
    }

    @Override
    public TYPE withInterfaceFunc(Function<IJavaBuilderContext, String> interfaceSupplier) {
        if (interfaceSupplier != null) {
            this.m_interfaces.add(JavaBuilderContextFunction.create(interfaceSupplier));
        }
        return (TYPE)((ITypeGenerator)this.thisInstance());
    }

    @Override
    public TYPE withInterfaces(Stream<String> interfaceReferences) {
        ((Stream)Ensure.notNull(interfaceReferences)).forEach(this::withInterface);
        return (TYPE)((ITypeGenerator)this.thisInstance());
    }

    @Override
    public TYPE withoutInterface(String toRemove) {
        return this.withoutInterface((JavaBuilderContextFunction<String> f) -> f.apply().filter(Predicate.isEqual(toRemove)).isPresent());
    }

    @Override
    public TYPE withoutInterface(Predicate<JavaBuilderContextFunction<String>> filter) {
        if (filter == null) {
            this.m_interfaces.clear();
        } else {
            this.m_interfaces.removeIf(filter);
        }
        return (TYPE)((ITypeGenerator)this.thisInstance());
    }

    @Override
    public Optional<String> superClass() {
        return this.superClassFunc().flatMap(JavaBuilderContextFunction::apply);
    }

    @Override
    public Optional<String> superClass(IJavaBuilderContext context) {
        return this.superClassFunc().map(f -> (String)f.apply(context));
    }

    @Override
    public Optional<JavaBuilderContextFunction<String>> superClassFunc() {
        return Optional.ofNullable(this.m_superClass);
    }

    @Override
    public TYPE withSuperClass(String superType) {
        this.m_superClass = JavaBuilderContextFunction.orNull(superType);
        return (TYPE)((ITypeGenerator)this.thisInstance());
    }

    @Override
    public <A extends IApiSpecification> TYPE withSuperClassFrom(Class<A> apiDefinition, Function<A, String> superClassSupplier) {
        this.m_superClass = new ApiFunction<A, String>(apiDefinition, superClassSupplier);
        return (TYPE)((ITypeGenerator)this.thisInstance());
    }

    @Override
    public TYPE withSuperClassFunc(Function<IJavaBuilderContext, String> superClassSupplier) {
        this.m_superClass = JavaBuilderContextFunction.orNull(superClassSupplier);
        return (TYPE)((ITypeGenerator)this.thisInstance());
    }

    @Override
    public String fullyQualifiedName() {
        return (String)this.m_fullyQualifiedName.computeIfAbsentAndGet(this::buildFullyQualifiedName);
    }

    @Override
    public String qualifier() {
        return (String)this.m_qualifier.computeIfAbsentAndGet(() -> this.buildQualifier()[0]);
    }

    /*
     * Exception decompiling
     */
    protected String[] buildQualifier() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String buildFullyQualifiedName() {
        String[] buildQualifier = this.buildQualifier();
        String qualifier = buildQualifier[0];
        String delimiter = buildQualifier[1];
        if (delimiter == null) {
            int lastDotPos = qualifier.lastIndexOf(46);
            boolean isInnerType = lastDotPos > 0 && Character.isUpperCase(qualifier.charAt(lastDotPos + 1));
            delimiter = isInnerType ? "$" : ".";
        }
        return qualifier + delimiter + this.elementName().orElseThrow(() -> Ensure.newFail((CharSequence)"Cannot calculate the fully qualified name if the class name (elementName) is not set.", (Object[])new Object[0]));
    }

    @Override
    public Stream<IFieldGenerator<?>> fields() {
        return this.m_members.stream().filter(SortedMemberEntry::isField).map(SortedMemberEntry::generator).map(g -> (IFieldGenerator)g);
    }

    @Override
    public TYPE withField(IFieldGenerator<?> generator, Object ... sortObject) {
        this.m_members.add(new SortedMemberEntry(TypeGenerator.applyConnection(generator, this), sortObject));
        return (TYPE)((ITypeGenerator)this.thisInstance());
    }

    @Override
    public TYPE withoutField(Predicate<IFieldGenerator<?>> removalFilter) {
        this.removeMemberIf(IFieldGenerator.class, removalFilter);
        return (TYPE)((ITypeGenerator)this.thisInstance());
    }

    protected <T extends IMemberGenerator<?>, P extends IMemberGenerator<?>> void removeMemberIf(Class<T> type, Predicate<P> removalFilter) {
        Iterator<SortedMemberEntry> it = this.m_members.iterator();
        while (it.hasNext()) {
            SortedMemberEntry entry = it.next();
            if (!entry.hasType(type)) continue;
            IMemberGenerator<?> generator = entry.generator();
            if (removalFilter != null && !removalFilter.test(generator)) continue;
            it.remove();
            TypeGenerator.applyConnection(generator, null);
        }
    }

    @Override
    public Stream<IMethodGenerator<?, ?>> methods() {
        return this.m_members.stream().filter(SortedMemberEntry::isMethod).map(SortedMemberEntry::generator).map(g -> (IMethodGenerator)g);
    }

    @Override
    public TYPE withMethod(IMethodGenerator<?, ?> builder, Object ... sortObject) {
        this.m_members.add(new SortedMemberEntry(TypeGenerator.applyConnection(builder, this), sortObject));
        return (TYPE)((ITypeGenerator)this.thisInstance());
    }

    @Override
    public TYPE withoutMethod(Predicate<IMethodGenerator<?, ?>> removalFilter) {
        this.removeMemberIf(IMethodGenerator.class, removalFilter);
        return (TYPE)((ITypeGenerator)this.thisInstance());
    }

    @Override
    public TYPE withoutMethod(String identifier, IJavaBuilderContext context) {
        this.removeMemberIf(IMethodGenerator.class, m -> Objects.equals(((IMethodGenerator)m).identifier(context), identifier));
        return (TYPE)((ITypeGenerator)this.thisInstance());
    }

    @Override
    public Optional<IMethodGenerator<?, ?>> method(String methodId, IJavaBuilderContext context, boolean includeTypeArguments) {
        Ensure.notBlank((CharSequence)methodId);
        return this.methods().filter(m -> methodId.equals(m.identifier(context, includeTypeArguments))).findAny();
    }

    @Override
    public Stream<ITypeGenerator<?>> types() {
        return this.m_members.stream().filter(SortedMemberEntry::isType).map(SortedMemberEntry::generator).map(g -> (ITypeGenerator)g);
    }

    @Override
    public Optional<ITypeGenerator<?>> type(String simpleName) {
        Ensure.notBlank((CharSequence)simpleName);
        return this.types().filter(t -> simpleName.equals(t.elementName().orElse(null))).findAny();
    }

    @Override
    public TYPE withoutAllMethodsImplemented() {
        this.m_addAllNecessaryMethods = false;
        this.m_unimplementedMethodsTransformer = null;
        this.m_unimplementedMethodSortOrderProvider = null;
        return (TYPE)((ITypeGenerator)this.thisInstance());
    }

    @Override
    public TYPE withAllMethodsImplemented() {
        return this.withAllMethodsImplemented(null);
    }

    @Override
    public TYPE withAllMethodsImplemented(IWorkingCopyTransformer callbackForMethodsAdded) {
        return this.withAllMethodsImplemented(callbackForMethodsAdded, null);
    }

    @Override
    public TYPE withAllMethodsImplemented(IWorkingCopyTransformer callbackForMethodsAdded, Function<IMethodGenerator<?, ?>, Object[]> methodSortOrderProvider) {
        this.m_addAllNecessaryMethods = true;
        this.m_unimplementedMethodsTransformer = callbackForMethodsAdded;
        this.m_unimplementedMethodSortOrderProvider = methodSortOrderProvider;
        return (TYPE)((ITypeGenerator)this.thisInstance());
    }

    @Override
    public boolean isWithAllMethodsImplemented() {
        return this.m_addAllNecessaryMethods;
    }

    @Override
    public TYPE withType(ITypeGenerator<?> generator, Object ... sortObject) {
        Ensure.isFalse((boolean)(generator instanceof ICompilationUnitGenerator), (CharSequence)"A {} cannot be added as nested type. Use a {} instead.", (Object[])new Object[]{PrimaryTypeGenerator.class.getSimpleName(), TypeGenerator.class.getSimpleName()});
        this.m_members.add(new SortedMemberEntry(TypeGenerator.applyConnection(generator, this), sortObject));
        return (TYPE)((ITypeGenerator)this.thisInstance());
    }

    @Override
    public TYPE withoutType(String simpleName) {
        return this.withoutType((ITypeGenerator<?> t) -> Objects.equals(simpleName, t.elementName().orElse(null)));
    }

    @Override
    public TYPE withoutType(Predicate<ITypeGenerator<?>> removalFilter) {
        this.removeMemberIf(ITypeGenerator.class, removalFilter);
        return (TYPE)((ITypeGenerator)this.thisInstance());
    }

    protected static <T extends IMemberGenerator<?>> T applyConnection(T child, IJavaElementGenerator<?> parent) {
        if (child instanceof AbstractMemberGenerator) {
            ((AbstractMemberGenerator)child).withDeclaringGenerator(parent);
        }
        return child;
    }

    @Override
    public Stream<ITypeParameterGenerator<?>> typeParameters() {
        return this.m_typeParameters.stream();
    }

    @Override
    public TYPE withTypeParameter(ITypeParameterGenerator<?> typeParameter) {
        this.m_typeParameters.add((ITypeParameterGenerator)Ensure.notNull(typeParameter));
        return (TYPE)((ITypeGenerator)this.thisInstance());
    }

    @Override
    public TYPE withoutTypeParameter(String elementName) {
        Ensure.notNull((Object)elementName);
        this.m_typeParameters.removeIf(generator -> elementName.equals(generator.elementName().orElse(null)));
        return (TYPE)((ITypeGenerator)this.thisInstance());
    }

    @Override
    public Optional<String> getDeclaringFullyQualifiedName() {
        return Strings.notBlank((CharSequence)this.m_declaringFullyQualifiedName);
    }

    @Override
    public TYPE setDeclaringFullyQualifiedName(String parentFullyQualifiedName) {
        this.m_declaringFullyQualifiedName = parentFullyQualifiedName;
        return (TYPE)((ITypeGenerator)this.thisInstance());
    }

    @Override
    public IType getHierarchyType(IJavaBuilderContext context) {
        return (IType)context.properties().computeIfAbsent(HIERARCHY_TYPE_KEY, k -> this.createHierarchyType(context));
    }

    protected IType createHierarchyType(IJavaBuilderContext context) {
        IJavaEnvironment javaEnvironment = context.environment().orElseThrow(() -> Ensure.newFail((CharSequence)"Cannot override a method without Java environment.", (Object[])new Object[0]));
        String targetPackage = "not.existing.scout.sdk.tmp_pck";
        String typeName = "ScoutSdkTempClass__" + HIERARCHY_TYPE_COUNTER.getAndIncrement();
        ITypeGenerator hierarchyTypeGenerator = ((PrimaryTypeGenerator)((PrimaryTypeGenerator)PrimaryTypeGenerator.create().withPackageName(targetPackage)).withElementName(typeName)).withInterfaces((Stream)this.interfacesFunc().map(af -> (String)af.apply(context)));
        this.superClassFunc().map(af -> (String)af.apply(context)).ifPresent(((PrimaryTypeGenerator)hierarchyTypeGenerator)::withSuperClass);
        StringBuilder hierarchyTypeSource = hierarchyTypeGenerator.toJavaSource(javaEnvironment);
        javaEnvironment.registerCompilationUnitOverride(hierarchyTypeSource, targetPackage, typeName + ".java");
        return javaEnvironment.requireType(targetPackage + "." + typeName);
    }

    private /* synthetic */ IllegalArgumentException lambda$buildQualifier$31() {
        return Ensure.newFail((CharSequence)"Cannot calculate the fully qualified name of generator '{}' if no parent context is available.", (Object[])new Object[]{this.elementName().orElse(null)});
    }

    private static /* synthetic */ String[] lambda$buildQualifier$30() {
        return new String[]{"", ""};
    }

    private static class UnimplementedMethodGenerator
    extends MethodOverrideGenerator<UnimplementedMethodGenerator, IMethodBodyBuilder<?>> {
        protected UnimplementedMethodGenerator(IWorkingCopyTransformer transformer) {
            super(transformer);
        }

        protected static Stream<IMethodGenerator<?, ?>> create(ITypeGenerator<?> typeGenerator, IJavaBuilderContext context, IWorkingCopyTransformer transformer) {
            return UnimplementedMethodGenerator.getUnimplementedMethods(typeGenerator.getHierarchyType(context)).map(m -> UnimplementedMethodGenerator.toMethodGenerator(typeGenerator, m, transformer));
        }

        protected static IMethodGenerator<?, ?> toMethodGenerator(IJavaElementGenerator<?> typeGenerator, IMethod unimplementedMethod, IWorkingCopyTransformer transformer) {
            UnimplementedMethodGenerator generator = (UnimplementedMethodGenerator)((UnimplementedMethodGenerator)new UnimplementedMethodGenerator(transformer).withDeclaringGenerator(typeGenerator)).withElementName(unimplementedMethod.elementName());
            unimplementedMethod.parameters().stream().map(UnimplementedMethodGenerator::toMethodParamGenerator).forEach(generator::withParameter);
            return generator;
        }

        protected static IMethodParameterGenerator<?> toMethodParamGenerator(IMethodParameter model) {
            return MethodParameterGenerator.create().withDataType(model.dataType().name());
        }

        protected static Stream<IMethod> getUnimplementedMethods(IType type) {
            LinkedHashMap abstractMethodIds = type.methods().withSuperTypes(true).stream().filter(method -> !Flags.isDefaultMethod(method.flags()) && !Flags.isStatic(method.flags())).filter(method -> Flags.isAbstract(method.flags()) || Flags.isInterface(method.flags()) || Flags.isInterface(method.requireDeclaringType().flags())).collect(Collectors.toMap(IMethod::identifier, Function.identity(), (u, v) -> u, LinkedHashMap::new));
            type.methods().withSuperClasses(true).stream().filter(m -> !Flags.isPrivate(m.flags()) && !Flags.isAbstract(m.flags())).map(IMethod::identifier).forEach(abstractMethodIds::remove);
            return abstractMethodIds.values().stream();
        }
    }
}

