/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.widgetmap;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.s.widgetmap.IdObjectType;
import org.eclipse.scout.sdk.core.s.widgetmap.IdObjectTypeMap;
import org.eclipse.scout.sdk.core.s.widgetmap.IdObjectTypeMapReference;
import org.eclipse.scout.sdk.core.s.widgetmap.IdObjectTypeMapUtils;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataTypeOwner;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeElement;
import org.eclipse.scout.sdk.core.typescript.model.api.IObjectLiteral;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.core.util.visitor.DefaultDepthFirstVisitor;
import org.eclipse.scout.sdk.core.util.visitor.IDepthFirstVisitor;
import org.eclipse.scout.sdk.core.util.visitor.TreeTraversals;
import org.eclipse.scout.sdk.core.util.visitor.TreeVisitResult;

public class WidgetMap
extends IdObjectTypeMap {
    private final IES6Class m_mainWidget;
    private final FinalValue<Optional<IdObjectTypeMapReference>> m_superWidgetMapReference = new FinalValue();
    private final FinalValue<Optional<IES6Class>> m_tableClass = new FinalValue();

    protected WidgetMap(String name, IObjectLiteral model, IES6Class mainWidget, Collection<String> usedNames) {
        super(name, model, usedNames);
        this.m_mainWidget = mainWidget;
    }

    public static Optional<WidgetMap> create(String widgetOrModelName, IObjectLiteral widgetModel, IES6Class mainWidget) {
        if (widgetOrModelName == null || widgetModel == null) {
            return Optional.empty();
        }
        return WidgetMap.create(widgetOrModelName, widgetModel, mainWidget, IdObjectTypeMapUtils.calculateUsedNames((INodeElement)widgetModel));
    }

    public static Optional<WidgetMap> create(String widgetOrModelName, IObjectLiteral widgetModel, IES6Class mainWidget, Collection<String> usedNames) {
        if (widgetOrModelName == null || widgetModel == null || usedNames == null) {
            return Optional.empty();
        }
        return Optional.of(widgetOrModelName).map(n -> Strings.removeSuffix((String)n, (CharSequence)"Model")).map(n -> n + "WidgetMap").map(n -> new WidgetMap((String)n, widgetModel, mainWidget, usedNames));
    }

    public Optional<IES6Class> mainWidget() {
        return Optional.ofNullable(this.m_mainWidget);
    }

    @Override
    protected Map<String, IdObjectType> parseElements() {
        if (this.widgetClass().isEmpty()) {
            return Collections.emptyMap();
        }
        final LinkedHashMap<String, IdObjectType> widgets = new LinkedHashMap<String, IdObjectType>();
        TreeTraversals.create((IDepthFirstVisitor)new DefaultDepthFirstVisitor<IObjectLiteral>(){
            private final Deque<IObjectLiteral> m_ancestors = new ArrayDeque<IObjectLiteral>();

            public TreeVisitResult preVisit(IObjectLiteral element, int level, int index) {
                TreeVisitResult result = TreeVisitResult.CONTINUE;
                if (element == null) {
                    result = TreeVisitResult.SKIP_SUBTREE;
                } else if (level > 0) {
                    result = WidgetMap.this.collectIdObjectType(element, this.m_ancestors, idObjectType -> Optional.ofNullable(widgets.put(idObjectType.id(), idObjectType)).ifPresent(iot -> WidgetMap.this.createDuplicateIdWarning(iot.id())));
                }
                this.m_ancestors.addLast(element);
                return result;
            }

            public boolean postVisit(IObjectLiteral element, int level, int index) {
                this.m_ancestors.removeLast();
                return true;
            }
        }, IObjectLiteral::childObjectLiterals).traverse((Object)this.model());
        return widgets;
    }

    protected Optional<IES6Class> tableClass() {
        return (Optional)this.m_tableClass.computeIfAbsentAndGet(() -> this.classByObjectType("Table"));
    }

    protected boolean isWidget(IdObjectType idObjectType) {
        return this.widgetClass().filter(clazz -> idObjectType.objectType().isInstanceOf((IES6Class)clazz)).isPresent();
    }

    protected boolean isTable(IdObjectType idObjectType) {
        return this.tableClass().filter(clazz -> idObjectType.objectType().isInstanceOf((IES6Class)clazz)).isPresent();
    }

    protected TreeVisitResult collectIdObjectType(IObjectLiteral element, Deque<IObjectLiteral> ancestors, Consumer<IdObjectType> collector) {
        IdObjectType idObjectType = IdObjectType.create(element, this.usedNames(), this.scoutJsModel().orElse(null)).orElse(null);
        if (idObjectType == null) {
            return TreeVisitResult.CONTINUE;
        }
        if (this.isTable(idObjectType)) {
            this.handleTable(element, idObjectType, ancestors);
            collector.accept(idObjectType);
            return TreeVisitResult.SKIP_SUBTREE;
        }
        if (this.isWidget(idObjectType)) {
            collector.accept(idObjectType);
        }
        return TreeVisitResult.CONTINUE;
    }

    protected void handleTable(IObjectLiteral element, IdObjectType idObjectType, Deque<IObjectLiteral> ancestors) {
        String name = idObjectType.id();
        if ("Table".equals(name) || name.equals(idObjectType.objectType().es6Class().name())) {
            name = Optional.ofNullable(ancestors.peekLast()).flatMap(ol -> IdObjectType.create(ol, this.usedNames(), this.scoutJsModel().orElse(null))).map(iot -> iot.id() + "Table").orElse(name);
        }
        idObjectType.objectType().withNewClassNameAndMaps(name, element);
    }

    @Override
    protected Set<IdObjectTypeMapReference> parseIdObjectTypeMapReferences() {
        IES6Class widgetClass = this.widgetClass().orElse(null);
        return Stream.concat(this.superWidgetMapReference().stream(), this.elements().values().stream().flatMap(element -> element.objectType().widgetMap().flatMap(IdObjectTypeMapReference::create).or(() -> element.objectType().es6Class().field("widgetMap").flatMap(IDataTypeOwner::dataType).filter(IES6Class.class::isInstance).map(IES6Class.class::cast).filter(es6Class -> es6Class != widgetClass).flatMap(IdObjectTypeMapReference::create)).stream())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Optional<IdObjectTypeMapReference> superWidgetMapReference() {
        return (Optional)this.m_superWidgetMapReference.computeIfAbsentAndGet(this::parseSuperWidgetMapReference);
    }

    protected Optional<IdObjectTypeMapReference> parseSuperWidgetMapReference() {
        IES6Class widgetClass = this.widgetClass().orElse(null);
        return this.mainWidget().stream().flatMap(mainWidget -> mainWidget.supers().withSuperInterfaces(false).stream()).takeWhile(es6Class -> es6Class != widgetClass).flatMap(es6Class -> es6Class.field("widgetMap").stream()).findFirst().flatMap(IDataTypeOwner::dataType).filter(IES6Class.class::isInstance).map(IES6Class.class::cast).flatMap(IdObjectTypeMapReference::create);
    }

    @Override
    public boolean isIdObjectTypeMapReferencesEmpty() {
        return super.isIdObjectTypeMapReferencesEmpty() || this.superWidgetMapReference().map(reference -> this.idObjectTypeMapReferences().size() == 1 && this.idObjectTypeMapReferences().contains(reference)).orElse(false) != false;
    }
}

