/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.provisional.api;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Optional;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.tm.internal.terminal.control.impl.TerminalPlugin;
import org.osgi.framework.Bundle;

public final class Logger {
    public static final String TRACE_DEBUG_LOG = "org.eclipse.tm.terminal.control/debug/log";
    public static final String TRACE_DEBUG_LOG_CHAR = "org.eclipse.tm.terminal.control/debug/log/char";
    public static final String TRACE_DEBUG_LOG_VT100BACKEND = "org.eclipse.tm.terminal.control/debug/log/VT100Backend";
    public static final String TRACE_DEBUG_LOG_HOVER = "org.eclipse.tm.terminal.control/debug/log/hover";
    private static PrintStream logStream;
    private static StackWalker walker;
    private static boolean underTest;

    static {
        IPath logFile;
        boolean createLogFile;
        walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        underTest = false;
        boolean bl = createLogFile = TerminalPlugin.isOptionEnabled(TRACE_DEBUG_LOG) || TerminalPlugin.isOptionEnabled(TRACE_DEBUG_LOG_CHAR) || TerminalPlugin.isOptionEnabled(TRACE_DEBUG_LOG_VT100BACKEND) || TerminalPlugin.isOptionEnabled(TRACE_DEBUG_LOG_HOVER);
        if (createLogFile && TerminalPlugin.getDefault() != null && (logFile = Platform.getStateLocation((Bundle)TerminalPlugin.getDefault().getBundle())) != null && logFile.toFile().isDirectory()) {
            logFile = logFile.append("tmterminal.log");
            try {
                logStream = new PrintStream(new FileOutputStream(logFile.toFile(), true));
            }
            catch (Exception ex) {
                logStream = System.err;
                logStream.println("Exception when opening log file -- logging to stderr!");
                ex.printStackTrace(logStream);
            }
        }
    }

    public static void setUnderTest(boolean underTest) {
        Logger.underTest = underTest;
    }

    public static final String encode(String message) {
        boolean encoded = false;
        StringBuffer buf = new StringBuffer(message.length() + 32);
        int i = 0;
        while (i < message.length()) {
            char c = message.charAt(i);
            switch (c) {
                case '\'': 
                case '\\': {
                    buf.append('\\');
                    buf.append(c);
                    encoded = true;
                    break;
                }
                case '\r': {
                    buf.append('\\');
                    buf.append('r');
                    encoded = true;
                    break;
                }
                case '\n': {
                    buf.append('\\');
                    buf.append('n');
                    encoded = true;
                    break;
                }
                case '\t': {
                    buf.append('\\');
                    buf.append('t');
                    encoded = true;
                    break;
                }
                case '\f': {
                    buf.append('\\');
                    buf.append('f');
                    encoded = true;
                    break;
                }
                case '\b': {
                    buf.append('\\');
                    buf.append('b');
                    encoded = true;
                    break;
                }
                default: {
                    if (c <= '\u000f') {
                        buf.append('\\');
                        buf.append('x');
                        buf.append('0');
                        buf.append(Integer.toHexString(c));
                        encoded = true;
                        break;
                    }
                    if (c >= ' ' && c < '\u007f') {
                        buf.append(c);
                        break;
                    }
                    if (c <= '\u00ff') {
                        buf.append('\\');
                        buf.append('x');
                        buf.append(Integer.toHexString(c));
                        encoded = true;
                        break;
                    }
                    buf.append('\\');
                    buf.append('u');
                    if (c <= '\u0fff') {
                        buf.append('0');
                    }
                    buf.append(Integer.toHexString(c));
                    encoded = true;
                }
            }
            ++i;
        }
        if (encoded) {
            return buf.toString();
        }
        return message;
    }

    public static final boolean isLogEnabled() {
        return logStream != null;
    }

    public static final void log(String message) {
        if (logStream != null) {
            logStream.println(Logger.getCallSiteDescription() + ": " + message);
            logStream.flush();
        }
    }

    public static final void logError(String message) {
        Logger.logStatus((IStatus)new Status(4, "org.eclipse.tm.terminal.control", 0, message, null));
    }

    public static final void logException(Exception ex) {
        if (underTest) {
            throw new RuntimeException("Terminal Under Test - examine cause for real failure", ex);
        }
        Logger.logStatus((IStatus)new Status(4, "org.eclipse.tm.terminal.control", 0, ex.getMessage(), (Throwable)ex));
    }

    public static final void logStatus(IStatus status) {
        if (TerminalPlugin.getDefault() != null) {
            TerminalPlugin.getDefault().getLog().log(status);
        } else {
            System.err.println(status);
            if (status.getException() != null) {
                status.getException().printStackTrace();
            }
        }
        if (logStream != null) {
            logStream.println(Logger.getCallSiteDescription() + ": " + String.valueOf(status));
            if (status.getException() != null) {
                status.getException().printStackTrace(logStream);
            }
        }
    }

    private static String getCallSiteDescription() {
        Optional stackFrame = walker.walk(stream -> stream.filter(f -> f.getDeclaringClass() != Logger.class).findFirst());
        int lineNumber = stackFrame.map(StackWalker.StackFrame::getLineNumber).orElse(0);
        String className = stackFrame.map(StackWalker.StackFrame::getDeclaringClass).map(Class::getName).map(name -> name.substring(name.lastIndexOf(46) + 1)).orElse("UnknownClass");
        String methodName = stackFrame.map(StackWalker.StackFrame::getMethodName).orElse("unknownMethod");
        String locationString = className + "." + methodName + ":" + lineNumber;
        return locationString;
    }
}

