/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.externalization;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.externalization.AttributesWrapper;
import org.eclipse.mylyn.internal.tasks.core.externalization.ContentHandlerWrapper;
import org.eclipse.mylyn.internal.tasks.core.externalization.SaxTaskListElementWriter;
import org.eclipse.mylyn.tasks.core.ITask;
import org.xml.sax.SAXException;

public class SaxQueryWriter
extends SaxTaskListElementWriter<RepositoryQuery> {
    public SaxQueryWriter(ContentHandlerWrapper handler) {
        super(handler);
    }

    @Override
    public void writeElement(RepositoryQuery query) throws SAXException {
        if (query.getClass() == RepositoryQuery.class) {
            AttributesWrapper attributes = new AttributesWrapper();
            attributes.addAttribute("Handle", query.getHandleIdentifier());
            attributes.addAttribute("ConnectorKind", query.getConnectorKind());
            attributes.addAttribute("Name", query.getSummary());
            attributes.addAttribute("QueryString", query.getUrl());
            attributes.addAttribute("RepositoryUrl", query.getRepositoryUrl());
            attributes.addAttribute("LastRefreshTimeStamp", query.getLastSynchronizedTimeStamp());
            this.handler.startElement("Query", attributes);
            this.writeAttributes(query);
            for (ITask task : query.getChildren()) {
                this.writeQueryHit(task);
            }
            this.handler.endElement("Query");
        } else {
            this.addError((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", String.format("Unable to externalize query \"%s\" as it is of an unsupported type %s", query.getHandleIdentifier(), query.getClass())));
        }
    }

    private void writeQueryHit(ITask task) throws SAXException {
        AttributesWrapper attributes = new AttributesWrapper();
        attributes.addAttribute("Handle", task.getHandleIdentifier());
        this.handler.startElement("QueryHit", attributes);
        this.handler.endElement("QueryHit");
    }
}

