/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.context;

import org.eclipse.wst.command.internal.env.context.PersistentContext;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.core.context.ResourceDefaults;
import org.eclipse.wst.command.internal.env.core.context.TransientResourceContext;
import org.eclipse.wst.command.internal.env.plugin.EnvPlugin;

public class PersistentResourceContext
extends PersistentContext
implements ResourceContext {
    private static PersistentResourceContext context_ = null;

    public static PersistentResourceContext getInstance() {
        if (context_ == null) {
            context_ = new PersistentResourceContext();
            context_.load();
        }
        return context_;
    }

    private PersistentResourceContext() {
        super(EnvPlugin.getInstance());
    }

    public void load() {
        this.setDefault("filesOverwrite", ResourceDefaults.getOverwriteFilesDefault());
        this.setDefault("createFolders", ResourceDefaults.getCreateFoldersDefault());
        this.setDefault("filesCheckout", ResourceDefaults.getCheckoutFilesDefault());
    }

    public void setOverwriteFilesEnabled(boolean enable) {
        this.setValue("filesOverwrite", enable);
    }

    public boolean isOverwriteFilesEnabled() {
        return this.getValueAsBoolean("filesOverwrite");
    }

    public void setCreateFoldersEnabled(boolean enable) {
        this.setValue("createFolders", enable);
    }

    public boolean isCreateFoldersEnabled() {
        return this.getValueAsBoolean("createFolders");
    }

    public void setCheckoutFilesEnabled(boolean enable) {
        this.setValue("filesCheckout", enable);
    }

    public boolean isCheckoutFilesEnabled() {
        return this.getValueAsBoolean("filesCheckout");
    }

    public ResourceContext copy() {
        TransientResourceContext cc = new TransientResourceContext();
        cc.setOverwriteFilesEnabled(this.isOverwriteFilesEnabled());
        cc.setCreateFoldersEnabled(this.isCreateFoldersEnabled());
        cc.setCheckoutFilesEnabled(this.isCheckoutFilesEnabled());
        return cc;
    }
}

