/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.launch;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.m2e.core.internal.Bundles;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.launch.AbstractMavenRuntime;
import org.eclipse.m2e.core.internal.launch.MavenRuntimeManagerImpl;
import org.eclipse.m2e.internal.launch.Messages;
import org.eclipse.m2e.workspace.WorkspaceState;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class MavenLaunchUtils {
    private MavenLaunchUtils() {
    }

    public static AbstractMavenRuntime getMavenRuntime(ILaunchConfiguration configuration) throws CoreException {
        String name;
        MavenRuntimeManagerImpl runtimeManager = MavenPluginActivator.getDefault().getMavenRuntimeManager();
        AbstractMavenRuntime runtime = runtimeManager.getRuntime(name = configuration.getAttribute("M2_RUNTIME", ""));
        if (runtime == null) {
            throw new CoreException(Status.error((String)NLS.bind((String)Messages.MavenLaunchUtils_error_no_maven_install, (Object)name)));
        }
        return runtime;
    }

    public static List<String> getCliResolver(AbstractMavenRuntime runtime) {
        if (runtime.getVersion().startsWith("3.")) {
            Bundle m2eWorkspaceCLIBundle = FrameworkUtil.getBundle(WorkspaceState.class);
            return Bundles.getClasspathEntries((Bundle)m2eWorkspaceCLIBundle);
        }
        return Collections.emptyList();
    }

    public static String quote(String string) {
        return string.contains(" ") ? "\"" + string + "\"" : string;
    }
}

