/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.suite.engine;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;
import org.junit.platform.suite.api.AfterSuite;
import org.junit.platform.suite.api.BeforeSuite;

final class LifecycleMethodUtils {
    private LifecycleMethodUtils() {
    }

    static List<Method> findBeforeSuiteMethods(Class<?> testClass, ThrowableCollector throwableCollector) {
        return LifecycleMethodUtils.findMethodsAndAssertStaticAndNonPrivate(testClass, BeforeSuite.class, HierarchyTraversalMode.TOP_DOWN, throwableCollector);
    }

    static List<Method> findAfterSuiteMethods(Class<?> testClass, ThrowableCollector throwableCollector) {
        return LifecycleMethodUtils.findMethodsAndAssertStaticAndNonPrivate(testClass, AfterSuite.class, HierarchyTraversalMode.BOTTOM_UP, throwableCollector);
    }

    private static List<Method> findMethodsAndAssertStaticAndNonPrivate(Class<?> testClass, Class<? extends Annotation> annotationType, HierarchyTraversalMode traversalMode, ThrowableCollector throwableCollector) {
        List methods = AnnotationSupport.findAnnotatedMethods(testClass, annotationType, (HierarchyTraversalMode)traversalMode);
        throwableCollector.execute(() -> methods.forEach(method -> {
            LifecycleMethodUtils.assertVoid(annotationType, method);
            LifecycleMethodUtils.assertStatic(annotationType, method);
            LifecycleMethodUtils.assertNonPrivate(annotationType, method);
            LifecycleMethodUtils.assertNoParameters(annotationType, method);
        }));
        return methods;
    }

    private static void assertStatic(Class<? extends Annotation> annotationType, Method method) {
        if (ModifierSupport.isNotStatic((Member)method)) {
            throw new JUnitException(String.format("@%s method '%s' must be static.", annotationType.getSimpleName(), method.toGenericString()));
        }
    }

    private static void assertNonPrivate(Class<? extends Annotation> annotationType, Method method) {
        if (ModifierSupport.isPrivate((Member)method)) {
            throw new JUnitException(String.format("@%s method '%s' must not be private.", annotationType.getSimpleName(), method.toGenericString()));
        }
    }

    private static void assertVoid(Class<? extends Annotation> annotationType, Method method) {
        if (!ReflectionUtils.returnsPrimitiveVoid((Method)method)) {
            throw new JUnitException(String.format("@%s method '%s' must not return a value.", annotationType.getSimpleName(), method.toGenericString()));
        }
    }

    private static void assertNoParameters(Class<? extends Annotation> annotationType, Method method) {
        if (method.getParameterCount() > 0) {
            throw new JUnitException(String.format("@%s method '%s' must not accept parameters.", annotationType.getSimpleName(), method.toGenericString()));
        }
    }
}

