/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.editors.autoconf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.autotools.core.AutotoolsPlugin;
import org.eclipse.cdt.autotools.ui.editors.AutoconfEditor;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfCaseElement;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfElement;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfElifElement;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfElseElement;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfForElement;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfIfElement;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfMacroArgumentElement;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfMacroElement;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfRootElement;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfSelectElement;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfUntilElement;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfWhileElement;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.IReconcilingParticipant;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class ProjectionFileUpdater
implements IProjectionListener {
    private IDocument fCachedDocument;
    private AutoconfEditor fEditor;
    private ProjectionViewer fViewer;
    private IReconcilingParticipant fParticipant;
    private boolean fAllowCollapsing = false;
    private boolean fCollapseMacroDef = false;
    private boolean fCollapseCase = false;
    private boolean fCollapseConditional = false;
    private boolean fCollapseLoop = false;

    public void install(AutoconfEditor editor, ProjectionViewer viewer) {
        this.fEditor = editor;
        this.fViewer = viewer;
        this.fViewer.addProjectionListener((IProjectionListener)this);
    }

    public void uninstall() {
        if (this.isInstalled()) {
            this.projectionDisabled();
            this.fViewer.removeProjectionListener((IProjectionListener)this);
            this.fViewer = null;
            this.fEditor = null;
        }
    }

    protected boolean isInstalled() {
        return this.fEditor != null;
    }

    public void projectionEnabled() {
        this.projectionDisabled();
        this.initialize();
        this.fParticipant = new ReconcilerParticipant();
        this.fEditor.addReconcilingParticipant(this.fParticipant);
    }

    public void projectionDisabled() {
        this.fCachedDocument = null;
        if (this.fParticipant != null) {
            this.fEditor.addReconcilingParticipant(this.fParticipant);
            this.fParticipant = null;
        }
    }

    public void initialize() {
        if (!this.isInstalled()) {
            return;
        }
        this.initializePreferences();
        try {
            ProjectionAnnotationModel model;
            IDocumentProvider provider = this.fEditor.getDocumentProvider();
            this.fCachedDocument = provider.getDocument((Object)this.fEditor.getEditorInput());
            this.fAllowCollapsing = true;
            AutoconfElement fInput = this.fEditor.getRootElement();
            if (fInput != null && (model = this.fEditor.getAdapter(ProjectionAnnotationModel.class)) != null) {
                Map<AutoconfProjectionAnnotation, Position> additions = this.computeAdditions(fInput);
                model.removeAllAnnotations();
                model.replaceAnnotations(null, additions);
            }
        }
        finally {
            this.fCachedDocument = null;
            this.fAllowCollapsing = false;
        }
    }

    private void initializePreferences() {
        IPreferenceStore store = AutotoolsPlugin.getDefault().getPreferenceStore();
        this.fCollapseMacroDef = store.getBoolean("editor_folding_default_macrodef");
        this.fCollapseCase = store.getBoolean("editor_folding_default_case");
        this.fCollapseConditional = store.getBoolean("editor_folding_default_conditional");
        this.fCollapseLoop = store.getBoolean("editor_folding_default_loop");
    }

    private Map<AutoconfProjectionAnnotation, Position> computeAdditions(AutoconfElement root) {
        HashMap<AutoconfProjectionAnnotation, Position> map = new HashMap<AutoconfProjectionAnnotation, Position>();
        if (root instanceof AutoconfRootElement) {
            this.computeAdditions(root.getChildren(), map);
        }
        return map;
    }

    private void computeAdditions(Object[] elements, Map<AutoconfProjectionAnnotation, Position> map) {
        int i = 0;
        while (i < elements.length) {
            AutoconfElement element = (AutoconfElement)elements[i];
            this.computeAdditions(element, map);
            if (element.hasChildren()) {
                this.computeAdditions(element.getChildren(), map);
            }
            ++i;
        }
    }

    private void computeAdditions(AutoconfElement element, Map<AutoconfProjectionAnnotation, Position> map) {
        Position position;
        boolean createProjection = false;
        boolean collapse = false;
        if (element instanceof AutoconfIfElement || element instanceof AutoconfElseElement || element instanceof AutoconfElifElement) {
            collapse = this.fAllowCollapsing && this.fCollapseConditional;
            createProjection = true;
        } else if (element instanceof AutoconfMacroElement) {
            collapse = this.fAllowCollapsing && this.fCollapseMacroDef;
            createProjection = true;
        } else if (element instanceof AutoconfMacroArgumentElement) {
            collapse = this.fAllowCollapsing && this.fCollapseMacroDef;
            createProjection = true;
        } else if (element instanceof AutoconfCaseElement) {
            collapse = this.fAllowCollapsing && this.fCollapseCase;
            createProjection = true;
        } else if (element instanceof AutoconfForElement || element instanceof AutoconfWhileElement || element instanceof AutoconfUntilElement || element instanceof AutoconfSelectElement) {
            collapse = this.fAllowCollapsing && this.fCollapseLoop;
            createProjection = true;
        }
        if (createProjection && (position = this.createProjectionPosition(element)) != null) {
            map.put(new AutoconfProjectionAnnotation(element, this.fAllowCollapsing, true), position);
        }
    }

    private Position createProjectionPosition(AutoconfElement element) {
        if (this.fCachedDocument == null) {
            return null;
        }
        int offset = 0;
        try {
            int startLine = 0;
            int endLine = 0;
            startLine = this.fCachedDocument.getLineOfOffset(element.getStartOffset());
            endLine = this.fCachedDocument.getLineOfOffset(element.getEndOffset());
            if (startLine != endLine) {
                offset = this.fCachedDocument.getLineOffset(startLine);
                int endOffset = this.fCachedDocument.getLineOffset(endLine) + this.fCachedDocument.getLineLength(endLine);
                return new Position(offset, endOffset - offset);
            }
        }
        catch (BadLocationException x) {
            return new Position(offset, this.fCachedDocument.getLength() - 1);
        }
        return null;
    }

    public void processReconcile() {
        if (!this.isInstalled()) {
            return;
        }
        ProjectionAnnotationModel model = this.fEditor.getAdapter(ProjectionAnnotationModel.class);
        if (model == null) {
            return;
        }
        try {
            IDocumentProvider provider = this.fEditor.getDocumentProvider();
            this.fCachedDocument = provider.getDocument((Object)this.fEditor.getEditorInput());
            this.fAllowCollapsing = false;
            HashMap<AutoconfProjectionAnnotation, Position> additions = new HashMap<AutoconfProjectionAnnotation, Position>();
            ArrayList<AutoconfProjectionAnnotation> deletions = new ArrayList<AutoconfProjectionAnnotation>();
            ArrayList<AutoconfProjectionAnnotation> updates = new ArrayList<AutoconfProjectionAnnotation>();
            Map<AutoconfProjectionAnnotation, Position> updated = this.computeAdditions(this.fEditor.getRootElement());
            Map<AutoconfElement, List<AutoconfProjectionAnnotation>> previous = this.createAnnotationMap((IAnnotationModel)model);
            for (AutoconfProjectionAnnotation annotation : updated.keySet()) {
                AutoconfElement element = annotation.getElement();
                Position position = updated.get((Object)annotation);
                List<AutoconfProjectionAnnotation> annotations = previous.get(element);
                if (annotations == null) {
                    additions.put(annotation, position);
                    continue;
                }
                Iterator<AutoconfProjectionAnnotation> x = annotations.iterator();
                while (x.hasNext()) {
                    AutoconfProjectionAnnotation a = x.next();
                    if (annotation.isComment() != a.isComment()) continue;
                    Position p = model.getPosition((Annotation)a);
                    if (p != null && !position.equals((Object)p)) {
                        p.setOffset(position.getOffset());
                        p.setLength(position.getLength());
                        updates.add(a);
                    }
                    x.remove();
                    break;
                }
                if (!annotations.isEmpty()) continue;
                previous.remove(element);
            }
            for (List<AutoconfProjectionAnnotation> list : previous.values()) {
                int size = list.size();
                int i = 0;
                while (i < size) {
                    deletions.add(list.get(i));
                    ++i;
                }
            }
            this.match(model, deletions, additions, updates);
            Annotation[] removals = new Annotation[deletions.size()];
            deletions.toArray(removals);
            Annotation[] changes = new Annotation[updates.size()];
            updates.toArray(changes);
            model.modifyAnnotations(removals, additions, changes);
        }
        finally {
            this.fCachedDocument = null;
            this.fAllowCollapsing = true;
        }
    }

    private void match(ProjectionAnnotationModel model, List<AutoconfProjectionAnnotation> deletions, Map<AutoconfProjectionAnnotation, Position> additions, List<AutoconfProjectionAnnotation> changes) {
        if (deletions.isEmpty() || additions.isEmpty() && changes.isEmpty()) {
            return;
        }
        ArrayList<AutoconfProjectionAnnotation> newDeletions = new ArrayList<AutoconfProjectionAnnotation>();
        ArrayList<AutoconfProjectionAnnotation> newChanges = new ArrayList<AutoconfProjectionAnnotation>();
        Iterator<AutoconfProjectionAnnotation> deletionIterator = deletions.iterator();
        block0: while (deletionIterator.hasNext()) {
            AutoconfProjectionAnnotation deleted = deletionIterator.next();
            Position deletedPosition = model.getPosition((Annotation)deleted);
            if (deletedPosition == null) continue;
            Iterator<AutoconfProjectionAnnotation> changesIterator = changes.iterator();
            while (changesIterator.hasNext()) {
                Position changedPosition;
                AutoconfProjectionAnnotation changed = changesIterator.next();
                if (deleted.isComment() != changed.isComment() || (changedPosition = model.getPosition((Annotation)changed)) == null || deletedPosition.getOffset() != changedPosition.getOffset()) continue;
                deletedPosition.setLength(changedPosition.getLength());
                deleted.setElement(changed.getElement());
                deletionIterator.remove();
                newChanges.add(deleted);
                changesIterator.remove();
                newDeletions.add(changed);
                continue block0;
            }
            Iterator<AutoconfProjectionAnnotation> additionsIterator = additions.keySet().iterator();
            while (additionsIterator.hasNext()) {
                AutoconfProjectionAnnotation added = additionsIterator.next();
                if (deleted.isComment() != added.isComment()) continue;
                Position addedPosition = additions.get((Object)added);
                if (deletedPosition.getOffset() != addedPosition.getOffset()) continue;
                deletedPosition.setLength(addedPosition.getLength());
                deleted.setElement(added.getElement());
                deletionIterator.remove();
                newChanges.add(deleted);
                additionsIterator.remove();
                continue block0;
            }
        }
        deletions.addAll(newDeletions);
        changes.addAll(newChanges);
    }

    private Map<AutoconfElement, List<AutoconfProjectionAnnotation>> createAnnotationMap(IAnnotationModel model) {
        HashMap<AutoconfElement, List<AutoconfProjectionAnnotation>> map = new HashMap<AutoconfElement, List<AutoconfProjectionAnnotation>>();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Annotation annotation = (Annotation)e.next();
            if (!(annotation instanceof AutoconfProjectionAnnotation)) continue;
            AutoconfProjectionAnnotation directive = (AutoconfProjectionAnnotation)annotation;
            ArrayList<AutoconfProjectionAnnotation> list = (ArrayList<AutoconfProjectionAnnotation>)map.get(directive.getElement());
            if (list == null) {
                list = new ArrayList<AutoconfProjectionAnnotation>(2);
                map.put(directive.getElement(), list);
            }
            list.add(directive);
        }
        return map;
    }

    private static class AutoconfProjectionAnnotation
    extends ProjectionAnnotation {
        private AutoconfElement fElement;
        private boolean fIsComment;

        public AutoconfProjectionAnnotation(AutoconfElement element, boolean isCollapsed, boolean isComment) {
            super(isCollapsed);
            this.fElement = element;
            this.fIsComment = isComment;
        }

        public AutoconfElement getElement() {
            return this.fElement;
        }

        public void setElement(AutoconfElement element) {
            this.fElement = element;
        }

        public boolean isComment() {
            return this.fIsComment;
        }
    }

    private class ReconcilerParticipant
    implements IReconcilingParticipant {
        private ReconcilerParticipant() {
        }

        @Override
        public void reconciled() {
            ProjectionFileUpdater.this.processReconcile();
        }
    }
}

