/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.launch;

import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.internal.core.InternalDebugCoreMessages;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.launch.LaunchConfigurationTargetedDelegate;

public abstract class CoreBuildLaunchConfigDelegate
extends LaunchConfigurationTargetedDelegate {
    protected ICBuildConfigurationManager configManager = CDebugCorePlugin.getService(ICBuildConfigurationManager.class);
    protected IToolChainManager toolChainManager = CDebugCorePlugin.getService(IToolChainManager.class);

    public static IProject getProject(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getMappedResources()[0].getProject();
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        IProject[] iProjectArray;
        IProject project = CoreBuildLaunchConfigDelegate.getProject(configuration);
        if (project != null) {
            IProject[] iProjectArray2 = new IProject[1];
            iProjectArray = iProjectArray2;
            iProjectArray2[0] = project;
        } else {
            iProjectArray = new IProject[]{};
        }
        return iProjectArray;
    }

    protected ICBuildConfiguration getBuildConfiguration(ILaunchConfiguration configuration, String mode, ILaunchTarget target, IProgressMonitor monitor) throws CoreException {
        String providerId;
        IToolChain toolchain;
        IProject project = CoreBuildLaunchConfigDelegate.getProject(configuration);
        String toolchainId = configuration.getAttribute("cdt.toolChain.id", null);
        if (toolchainId != null && (toolchain = this.toolChainManager.getToolChain(providerId = configuration.getAttribute("cdt.toolChain.type", ""), toolchainId)) != null) {
            return this.configManager.getBuildConfiguration(project, toolchain, mode, target, monitor);
        }
        HashMap properties = new HashMap();
        properties.putAll(target.getAttributes());
        for (IToolChain toolChain : this.toolChainManager.getToolChainsMatching(properties)) {
            ICBuildConfiguration buildConfig = this.configManager.getBuildConfiguration(project, toolChain, mode, target, monitor);
            if (buildConfig == null) continue;
            return buildConfig;
        }
        return null;
    }

    protected IBinary getBinary(ICBuildConfiguration buildConfig) throws CoreException {
        IBinary[] binaries = buildConfig.getBuildOutput();
        IBinary exeFile = null;
        IBinary[] iBinaryArray = binaries;
        int n = binaries.length;
        int n2 = 0;
        while (n2 < n) {
            IBinary binary = iBinaryArray[n2];
            if (binary.isExecutable()) {
                exeFile = binary;
                break;
            }
            ++n2;
        }
        if (exeFile == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.debug.core", InternalDebugCoreMessages.CoreBuildLaunchConfigDelegate_noBinaries));
        }
        return exeFile;
    }

    protected String getProgramPath(ILaunchConfiguration configuration, ICBuildConfiguration buildConfig) throws CoreException {
        String fullPath;
        String programName = configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
        if (programName.isBlank()) {
            IBinary exeFile = this.getBinary(buildConfig);
            return Paths.get(exeFile.getLocationURI()).toString();
        }
        Path path = new Path(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(programName));
        if (path.isAbsolute()) {
            fullPath = path.toOSString();
        } else {
            IProject project = CoreBuildLaunchConfigDelegate.getProject(configuration);
            fullPath = project.getFile((IPath)path).getLocation().toOSString();
        }
        return fullPath;
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        IProject project = CoreBuildLaunchConfigDelegate.getProject(configuration);
        return new IProject[]{project};
    }

    @Deprecated
    public static String getBuildAttributeName(String mode) {
        return "COREBUILD_" + mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, ILaunchTarget target, IProgressMonitor monitor) throws CoreException {
        int autoBuild = configuration.getAttribute("org.eclipse.cdt.launch.ATTR_BUILD_BEFORE_LAUNCH_ATTR", 2);
        if (autoBuild == 0) {
            return false;
        }
        ICBuildConfiguration buildConfig = this.getBuildConfiguration(configuration, mode, target, monitor);
        if (buildConfig != null) {
            CoreModel m;
            IProject project = CoreBuildLaunchConfigDelegate.getProject(configuration);
            CoreModel coreModel = m = CoreModel.getDefault();
            synchronized (coreModel) {
                IProjectDescription desc = project.getDescription();
                IBuildConfiguration[] bconfigs = project.getBuildConfigs();
                LinkedHashSet<String> names = new LinkedHashSet<String>();
                IBuildConfiguration[] iBuildConfigurationArray = bconfigs;
                int n = bconfigs.length;
                int n2 = 0;
                while (n2 < n) {
                    IBuildConfiguration bconfig = iBuildConfigurationArray[n2];
                    names.add(bconfig.getName());
                    ++n2;
                }
                names.add("");
                names.remove(buildConfig.getBuildConfiguration().getName());
                names.add(buildConfig.getBuildConfiguration().getName());
                desc.setBuildConfigs(names.toArray(new String[0]));
                desc.setActiveBuildConfig(buildConfig.getBuildConfiguration().getName());
                project.setDescription(desc, monitor);
            }
        }
        return this.superBuildForLaunch(configuration, mode, monitor);
    }
}

