/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.dom.rewrite;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.parser.TerminalToken;

public class TokenScanner {
    public static final int END_OF_FILE = 20001;
    public static final int LEXICAL_ERROR = 20002;
    public static final int DOCUMENT_ERROR = 20003;
    private final Scanner scanner;
    private final int endPosition;

    public TokenScanner(Scanner scanner) {
        this.scanner = scanner;
        this.endPosition = this.scanner.getSource().length - 1;
    }

    public Scanner getScanner() {
        return this.scanner;
    }

    public void setOffset(int offset) {
        this.scanner.resetTo(offset, this.endPosition);
    }

    public int getCurrentEndOffset() {
        return this.scanner.getCurrentTokenEndPosition() + 1;
    }

    public int getCurrentStartOffset() {
        return this.scanner.getCurrentTokenStartPosition();
    }

    public int getCurrentLength() {
        return this.getCurrentEndOffset() - this.getCurrentStartOffset();
    }

    public TerminalToken readNext(boolean ignoreComments) throws CoreException {
        TerminalToken curr = TerminalToken.TokenNameNotAToken;
        do {
            try {
                curr = this.scanner.getNextToken();
                if (curr == TerminalToken.TokenNameEOF) {
                    throw new CoreException(TokenScanner.createError(20001, "End Of File", null));
                }
            }
            catch (InvalidInputException e) {
                throw new CoreException(TokenScanner.createError(20002, e.getMessage(), e));
            }
        } while (ignoreComments && TokenScanner.isComment(curr));
        return curr;
    }

    public TerminalToken readNext(int offset, boolean ignoreComments) throws CoreException {
        this.setOffset(offset);
        return this.readNext(ignoreComments);
    }

    public int getNextStartOffset(int offset, boolean ignoreComments) throws CoreException {
        this.readNext(offset, ignoreComments);
        return this.getCurrentStartOffset();
    }

    public int getNextEndOffset(int offset, boolean ignoreComments) throws CoreException {
        this.readNext(offset, ignoreComments);
        return this.getCurrentEndOffset();
    }

    public void readToToken(TerminalToken tok) throws CoreException {
        TerminalToken curr = TerminalToken.TokenNameNotAToken;
        while ((curr = this.readNext(false)) != tok) {
        }
    }

    public void readToToken(TerminalToken tok, int offset) throws CoreException {
        this.setOffset(offset);
        this.readToToken(tok);
    }

    public int getTokenStartOffset(TerminalToken token, int startOffset) throws CoreException {
        this.readToToken(token, startOffset);
        return this.getCurrentStartOffset();
    }

    public int getTokenEndOffset(TerminalToken token, int startOffset) throws CoreException {
        this.readToToken(token, startOffset);
        return this.getCurrentEndOffset();
    }

    public int getPreviousTokenEndOffset(TerminalToken token, int startOffset) throws CoreException {
        this.setOffset(startOffset);
        int res = startOffset;
        TerminalToken curr = this.readNext(false);
        while (curr != token) {
            res = this.getCurrentEndOffset();
            curr = this.readNext(false);
        }
        return res;
    }

    public static boolean isComment(TerminalToken token) {
        return token == TerminalToken.TokenNameCOMMENT_BLOCK || token == TerminalToken.TokenNameCOMMENT_JAVADOC || token == TerminalToken.TokenNameCOMMENT_LINE;
    }

    public static boolean isModifier(TerminalToken token) {
        switch (token) {
            case TokenNameabstract: 
            case TokenNamefinal: 
            case TokenNamenative: 
            case TokenNameprivate: 
            case TokenNameprotected: 
            case TokenNamepublic: 
            case TokenNamestatic: 
            case TokenNamestrictfp: 
            case TokenNamesynchronized: 
            case TokenNametransient: 
            case TokenNamevolatile: {
                return true;
            }
        }
        return false;
    }

    public static IStatus createError(int code, String message, Throwable throwable) {
        return new Status(4, "org.eclipse.jdt.core", code, message, throwable);
    }
}

