/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.p2;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ExecutablesDescriptor;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.eclipse.ApplicationLauncherAction;
import org.eclipse.tea.library.build.p2.TeaEquinoxExecutableAction;

public class TeaApplicationLauncherAction
extends ApplicationLauncherAction {
    private final String id;
    private final Version version;
    private final String flavor;
    private final File platformLocation;
    private final File overrideLocation;

    public TeaApplicationLauncherAction(String id, Version version, String flavor, String executableName, File location, String[] configSpecs, File overrideLocation) {
        super(id, version, flavor, executableName, location, configSpecs);
        this.id = id;
        this.version = version;
        this.flavor = flavor;
        this.platformLocation = location;
        this.overrideLocation = overrideLocation;
    }

    protected Collection<IPublisherAction> createExecutablesActions(String[] configs) {
        ArrayList<IPublisherAction> actions = new ArrayList<IPublisherAction>(configs.length);
        int i = 0;
        while (i < configs.length) {
            boolean hasOverridden = true;
            ExecutablesDescriptor executables = TeaApplicationLauncherAction.createExecutablesFromLocation(this.overrideLocation, configs[i]);
            if (executables == null) {
                hasOverridden = false;
                executables = TeaApplicationLauncherAction.createExecutablesFromLocation(new File(this.platformLocation, "bin"), configs[i]);
                if (executables == null) {
                    executables = this.computeExecutables(configs[i]);
                }
            }
            TeaEquinoxExecutableAction action = new TeaEquinoxExecutableAction(executables, configs[i], this.id, this.version, this.flavor, !hasOverridden);
            actions.add((IPublisherAction)action);
            ++i;
        }
        return actions;
    }

    public static ExecutablesDescriptor createExecutablesFromLocation(File executablesFeatureLocation, String configSpec) {
        if (executablesFeatureLocation == null || !executablesFeatureLocation.exists()) {
            return null;
        }
        String[] config = AbstractPublisherAction.parseConfigSpec((String)configSpec);
        File result = new File(executablesFeatureLocation, config[0] + "/" + config[1] + "/" + config[2]);
        if (!result.exists() || !result.isDirectory()) {
            return null;
        }
        String launcherName = null;
        File[] fileArray = result.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.getName().toLowerCase().endsWith("c.exe") && !file.getName().toLowerCase().endsWith("c")) {
                if (file.getName().toLowerCase().endsWith(".exe")) {
                    launcherName = file.getName().substring(0, file.getName().length() - 4);
                    break;
                }
                launcherName = file.getName();
                break;
            }
            ++n2;
        }
        return new ExecutablesDescriptor(config[1], launcherName == null ? "launcher" : launcherName, result, new File[]{result});
    }
}

