/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.io;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.statet.internal.jcommons.io.AbstractArchiveStringUrl;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public abstract class AbstractNestedArchiveStringUrl
extends AbstractArchiveStringUrl {
    private volatile @Nullable URI innerArchiveUrl;
    private volatile @Nullable String innerArchiveUrlString;

    public AbstractNestedArchiveStringUrl(String urlString) {
        super(urlString);
    }

    @Override
    public final boolean isNested() {
        return true;
    }

    @Override
    public String getOuterArchiveScheme() {
        return "file";
    }

    @Override
    public final URI getInnerArchiveUrl() throws URISyntaxException {
        URI url = this.innerArchiveUrl;
        if (url == null) {
            this.innerArchiveUrl = url = new URI(this.getInnerArchiveUrlString());
        }
        return url;
    }

    @Override
    public final String getInnerArchiveUrlString() throws URISyntaxException {
        String urlString = this.innerArchiveUrlString;
        if (urlString == null) {
            this.innerArchiveUrlString = urlString = this.createInnerArchiveUrl(this.getUrlString());
        }
        return urlString;
    }

    protected abstract String createInnerArchiveUrl(String var1) throws URISyntaxException;
}

