/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.io;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.statet.jcommons.io.ArchiveUrl;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public abstract class AbstractArchiveStringUrl
implements ArchiveUrl {
    private volatile @Nullable URI url;
    private final String urlString;
    private volatile @Nullable URI outerArchiveUrl;
    private volatile @Nullable String outerArchiveUrlString;
    private volatile @Nullable String pathString;

    public AbstractArchiveStringUrl(String urlString) {
        this.urlString = urlString;
    }

    @Override
    public final URI getUrl() throws URISyntaxException {
        URI url = this.url;
        if (url == null) {
            this.url = url = new URI(this.urlString);
        }
        return url;
    }

    @Override
    public final String getUrlString() {
        return this.urlString;
    }

    @Override
    public final URI getOuterArchiveUrl() throws URISyntaxException {
        URI url = this.outerArchiveUrl;
        if (url == null) {
            this.outerArchiveUrl = url = new URI(this.getOuterArchiveUrlString());
        }
        return url;
    }

    @Override
    public final String getOuterArchiveUrlString() {
        String s = this.outerArchiveUrlString;
        if (s == null) {
            this.outerArchiveUrlString = s = this.createOuterArchiveUrl(this.urlString);
        }
        return s;
    }

    protected abstract String createOuterArchiveUrl(String var1);

    @Override
    public final String getInnerEntryPathString() {
        String s = this.pathString;
        if (s == null) {
            this.pathString = s = this.createEntryPath(this.urlString);
        }
        return s;
    }

    protected abstract String createEntryPath(String var1);

    public String toString() {
        return this.getUrlString();
    }
}

