/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.wizards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.papyrus.infra.architecture.ArchitectureDescriptionUtils;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureViewpoint;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModelUtils;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ExtensionServicesRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.util.EditorUtils;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.uml.diagram.wizards.Activator;
import org.eclipse.papyrus.uml.diagram.wizards.command.InitFromTemplateCommand;
import org.eclipse.papyrus.uml.diagram.wizards.command.NewPapyrusModelCommand;
import org.eclipse.papyrus.uml.diagram.wizards.messages.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.pages.INewPapyrusModelPage;
import org.eclipse.papyrus.uml.diagram.wizards.pages.NewModelWizardData;
import org.eclipse.papyrus.uml.diagram.wizards.pages.SelectArchitectureContextPage;
import org.eclipse.papyrus.uml.diagram.wizards.pages.SelectRepresentationKindPage;
import org.eclipse.papyrus.uml.diagram.wizards.pages.SelectStorageProviderPage;
import org.eclipse.papyrus.uml.diagram.wizards.providers.INewModelStorageProvider;
import org.eclipse.papyrus.uml.diagram.wizards.providers.NewModelStorageProviderRegistry;
import org.eclipse.papyrus.uml.diagram.wizards.providers.WorkspaceNewModelStorageProvider;
import org.eclipse.papyrus.uml.diagram.wizards.template.ModelTemplateDescription;
import org.eclipse.papyrus.uml.diagram.wizards.transformation.IGenerator;
import org.eclipse.papyrus.uml.tools.commands.ApplyProfileCommand;
import org.eclipse.papyrus.uml.tools.commands.RenameElementCommand;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class CreateModelWizard
extends Wizard
implements INewWizard {
    public static final String WIZARD_ID = "org.eclipse.papyrus.uml.diagram.wizards.createmodel";
    public static final String NEW_MODEL_SETTINGS = "NewModelWizard";
    private SelectStorageProviderPage selectStorageProviderPage;
    private SelectRepresentationKindPage selectRepresentationKindPage;
    protected SelectArchitectureContextPage selectArchitectureContextPage;
    private IWorkbench workbench;
    private NewModelStorageProviderRegistry storageProviderRegistry;
    private INewModelStorageProvider selectedStorageProvider;
    private Map<INewModelStorageProvider, List<IWizardPage>> providerPages = new HashMap<INewModelStorageProvider, List<IWizardPage>>();
    private Map<IWizardPage, INewModelStorageProvider> providersByPage = new HashMap<IWizardPage, INewModelStorageProvider>();
    private int startProviderPageIndex;
    private int endProviderPageIndex;
    protected IWizardPage newProjectPage;
    private final NewModelWizardData wizardData = new NewModelWizardData();
    protected static final String EXTENSION_POINT_ID = "org.eclipse.papyrus.uml.diagram.wizards.templates";

    public CreateModelWizard() {
        this.setWindowTitle(Messages.CreateModelWizard_new_papyrus_model_title);
        this.setDefaultPageImageDescriptor(Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.uml.diagram.wizards", (String)"icons/papyrus/PapyrusWizban_75x66.gif"));
    }

    public void addPages() {
        if (this.selectedStorageProvider.getArchitectureContextPage() != null) {
            this.addPageIfNotNull((IWizardPage)this.selectedStorageProvider.getArchitectureContextPage());
        } else {
            this.addPageIfNotNull((IWizardPage)this.selectArchitectureContextPage);
        }
        this.addPageIfNotNull((IWizardPage)this.selectStorageProviderPage);
        this.addPageIfNotNull(this.newProjectPage);
        this.startProviderPageIndex = this.getPageCount() - 1;
        for (INewModelStorageProvider iNewModelStorageProvider : this.getStorageProviders()) {
            ArrayList<IWizardPage> pageList = new ArrayList<IWizardPage>(3);
            for (IWizardPage iWizardPage : iNewModelStorageProvider.createPages()) {
                if (iWizardPage == null) continue;
                pageList.add(iWizardPage);
                this.providersByPage.put(iWizardPage, iNewModelStorageProvider);
                if (iWizardPage.equals((Object)this.selectedStorageProvider.getArchitectureContextPage())) continue;
                this.addPage(iWizardPage);
            }
            this.providerPages.put(iNewModelStorageProvider, pageList);
        }
        this.endProviderPageIndex = this.getPageCount();
        this.addPageIfNotNull((IWizardPage)this.selectRepresentationKindPage);
        INewPapyrusModelPage iNewPapyrusModelPage = this.getNewModelPage();
        if (iNewPapyrusModelPage != null) {
            iNewPapyrusModelPage.setNewModelWizardData(this.wizardData);
        }
    }

    protected void setNewProjectPage(IWizardPage page) {
        this.newProjectPage = page;
    }

    protected final void addPageIfNotNull(IWizardPage page) {
        if (page != null) {
            this.addPage(page);
        }
    }

    public boolean isInitModelWizard() {
        return false;
    }

    public boolean isCreateProjectWizard() {
        return false;
    }

    public boolean isCreateMultipleModelsWizard() {
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.initStorageProvider(workbench, selection);
        IDialogSettings workbenchSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(NEW_MODEL_SETTINGS);
        if (section == null) {
            section = workbenchSettings.addNewSection(NEW_MODEL_SETTINGS);
        }
        this.setDialogSettings(section);
        this.selectStorageProviderPage = this.createSelectStorageProviderPage();
        for (INewModelStorageProvider iNewModelStorageProvider : this.getStorageProviders()) {
            iNewModelStorageProvider.init(this, selection);
        }
        this.selectRepresentationKindPage = this.createSelectRepresentationKindPage();
    }

    public boolean performFinish() {
        String[] contextIds = this.getSelectedContexts();
        if (contextIds.length == 0) {
            return false;
        }
        SelectArchitectureContextPage selectArchitectureContextPage = this.getSelectArchitectureContextPage();
        if (selectArchitectureContextPage != null) {
            selectArchitectureContextPage.performFinish();
        }
        String contextId = contextIds[0];
        URI newURI = this.createNewModelURI(contextId);
        String[] viewpointIds = this.getSelectedViewpoints(contextId);
        this.createAndOpenPapyrusModel(newURI, contextId, viewpointIds);
        return true;
    }

    protected URI createNewModelURI(String contextId) {
        return this.getSelectedStorageProvider().createNewModelURI(contextId);
    }

    protected boolean createAndOpenPapyrusModel(URI newURI, String contextId, String[] viewpointIds) {
        if (newURI == null) {
            return false;
        }
        ServicesRegistry registry = this.createServicesRegistry();
        if (registry == null) {
            return false;
        }
        try {
            try {
                ModelSet modelSet = (ModelSet)registry.getService(ModelSet.class);
                this.createPapyrusModels(modelSet, newURI);
                this.initServicesRegistry(registry);
                this.initDomainModel(modelSet, contextId, viewpointIds);
                this.initDiagramModel(modelSet, contextId);
                this.initProfile(modelSet);
                this.initTemplate(modelSet);
                this.saveDiagram(modelSet);
                this.openDiagram(newURI);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
                this.selectRepresentationKindPage.setErrorMessage(e.getMessage());
                try {
                    registry.disposeRegistry();
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                registry.disposeRegistry();
            }
            catch (ServiceException serviceException) {}
        }
        return true;
    }

    private void initProfile(ModelSet modelSet) {
        boolean isProfileDefined;
        boolean isToApplyProfile = this.selectRepresentationKindPage.getProfileURI() != null;
        if (isToApplyProfile & (isProfileDefined = this.selectRepresentationKindPage.getProfileDefinitionStatus().isOK())) {
            this.applyProfile(modelSet);
        }
    }

    private void initTemplate(ModelSet modelSet) {
        boolean isToInitFromTemplateTransfo;
        boolean bl = isToInitFromTemplateTransfo = this.selectRepresentationKindPage.getTemplateTransfo().size() > 0;
        if (isToInitFromTemplateTransfo) {
            this.applyTemplateTransfo(modelSet);
        }
    }

    protected ServicesRegistry createServicesRegistry() {
        ExtensionServicesRegistry result = null;
        try {
            result = new ExtensionServicesRegistry("org.eclipse.papyrus.infra.core");
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        try {
            result.startServicesByClassKeys(new Class[]{ModelSet.class});
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return result;
    }

    protected void initServicesRegistry(ServicesRegistry registry) throws ServiceException {
        try {
            registry.startRegistry();
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        registry.getService(IPageManager.class);
    }

    protected String[] getSelectedContexts() {
        SelectArchitectureContextPage page = this.getSelectArchitectureContextPage();
        if (page != null) {
            return page.getSelectedContexts();
        }
        return null;
    }

    protected String[] getSelectedViewpoints() {
        SelectArchitectureContextPage page = this.getSelectArchitectureContextPage();
        if (page != null) {
            return page.getSelectViewpoints();
        }
        return null;
    }

    protected String[] getSelectedViewpoints(String contextId) {
        ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
        MergedArchitectureContext context = manager.getArchitectureContextById(contextId);
        ArrayList<String> availableViewpoints = new ArrayList<String>();
        for (MergedArchitectureViewpoint viewpoint : context.getViewpoints()) {
            availableViewpoints.add(viewpoint.getId());
        }
        List<String> selectedViewpoints = Arrays.asList(this.getSelectedViewpoints());
        selectedViewpoints.retainAll(availableViewpoints);
        return selectedViewpoints.toArray(new String[0]);
    }

    private SelectArchitectureContextPage getSelectArchitectureContextPage() {
        return this.selectArchitectureContextPage != null ? this.selectArchitectureContextPage : (this.selectedStorageProvider != null ? this.selectedStorageProvider.getArchitectureContextPage() : null);
    }

    public String getDiagramFileExtension(String contextId) {
        return this.getDiagramFileExtension(contextId, "di");
    }

    public String getDiagramFileExtension(String contextId, String defaultExtension) {
        MergedArchitectureContext context = ArchitectureDomainManager.getInstance().getArchitectureContextById(contextId);
        String extensionPrefix = context != null ? context.getExtensionPrefix() : null;
        return extensionPrefix != null && !extensionPrefix.trim().isEmpty() ? String.valueOf(extensionPrefix) + "." + defaultExtension : defaultExtension;
    }

    protected SelectArchitectureContextPage createSelectArchitectureContextPage() {
        return new SelectArchitectureContextPage();
    }

    protected SelectRepresentationKindPage createSelectRepresentationKindPage() {
        SelectRepresentationKindPage result = this.doCreateSelectRepresentationKindPage();
        result.setNewModelWizardData(this.wizardData);
        return result;
    }

    protected SelectRepresentationKindPage doCreateSelectRepresentationKindPage() {
        return new SelectRepresentationKindPage(this.createContextProvider());
    }

    protected SelectRepresentationKindPage.ContextProvider createContextProvider() {
        return new SelectRepresentationKindPage.ContextProvider(){

            @Override
            public String[] getCurrentContexts() {
                return CreateModelWizard.this.getSelectedContexts();
            }

            @Override
            public String[] getCurrentViewpoints() {
                return CreateModelWizard.this.getSelectedViewpoints();
            }
        };
    }

    protected void initDomainModel(ModelSet modelSet, String contextId, String[] viewpointIds) {
        boolean isToInitFromTemplate;
        boolean bl = isToInitFromTemplate = this.selectRepresentationKindPage.getTemplatePath() != null;
        if (isToInitFromTemplate) {
            this.initDomainModelFromTemplate(modelSet, contextId, viewpointIds);
        } else {
            this.createEmptyDomainModel(modelSet, contextId, viewpointIds);
        }
    }

    protected void applyProfile(ModelSet modelSet) {
        String profilePath = this.selectRepresentationKindPage.getProfileURI();
        Resource resource = modelSet.getResource(URI.createURI((String)profilePath), true);
        Profile profileToApply = (Profile)resource.getContents().get(0);
        Resource myModelUMLResource = UmlUtils.getUmlResource((ModelSet)modelSet);
        Package manipulatedModel = (Package)myModelUMLResource.getContents().get(0);
        ApplyProfileCommand applyProfileCommand = new ApplyProfileCommand(manipulatedModel, profileToApply, modelSet.getTransactionalEditingDomain());
        this.getCommandStack(modelSet).execute((Command)applyProfileCommand);
    }

    protected void applyTemplateTransfo(ModelSet modelSet) {
        IExtension[] extensions;
        List<ModelTemplateDescription> templateList = this.selectRepresentationKindPage.getTemplateTransfo();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] iExtensionArray = extensions = registry.getExtensionPoint(EXTENSION_POINT_ID).getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configElement = iConfigurationElementArray[n4];
                if (!"template".equals(configElement.getName()) && "transformation".equals(configElement.getName())) {
                    for (ModelTemplateDescription currentTemplate : templateList) {
                        if (!currentTemplate.getName().equals(configElement.getAttribute("name"))) continue;
                        try {
                            IGenerator iGenerator = (IGenerator)configElement.createExecutableExtension("Transformation");
                            iGenerator.setModelSet(modelSet);
                            iGenerator.execute();
                        }
                        catch (CoreException e) {
                            Activator.log.error((Throwable)e);
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected void initDomainModelFromTemplate(ModelSet modelSet, String contextId, String[] viewpointIds) {
        ArchitectureDescriptionUtils helper = new ArchitectureDescriptionUtils(modelSet);
        CompoundCommand cc = new CompoundCommand();
        cc.append((Command)new InitFromTemplateCommand(modelSet.getTransactionalEditingDomain(), modelSet, this.selectRepresentationKindPage.getTemplatePluginId(), this.selectRepresentationKindPage.getTemplatePath(), this.selectRepresentationKindPage.getNotationTemplatePath(), this.selectRepresentationKindPage.getDiTemplatePath()));
        cc.append(helper.switchArchitectureContextId(contextId));
        cc.append(helper.switchArchitectureViewpointIds(viewpointIds));
        this.getCommandStack(modelSet).execute((Command)cc);
    }

    protected void createEmptyDomainModel(ModelSet modelSet, String contextId, String[] viewpointIds) {
        try {
            ArchitectureDescriptionUtils helper = new ArchitectureDescriptionUtils(modelSet);
            Command command = helper.createNewModel(contextId, viewpointIds);
            this.getCommandStack(modelSet).execute(command);
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected void createPapyrusModels(ModelSet modelSet, URI newURIs) {
        NewPapyrusModelCommand command = new NewPapyrusModelCommand(modelSet, newURIs);
        this.getCommandStack(modelSet).execute((Command)command);
    }

    protected void openDiagram(URI newURI) {
        IWorkbenchPage page = this.workbench.getActiveWorkbenchWindow().getActivePage();
        if (page != null) {
            try {
                IEditorInput editorInput = this.createEditorInput(newURI);
                IDE.openEditor((IWorkbenchPage)page, (IEditorInput)editorInput, (String)this.getPreferredEditorID(editorInput), (boolean)true);
            }
            catch (PartInitException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    protected IEditorInput createEditorInput(URI uri) {
        return this.getSelectedStorageProvider().createEditorInput(uri);
    }

    protected String getPreferredEditorID(IEditorInput input) throws PartInitException {
        IEditorDescriptor desc;
        if (input instanceof IFileEditorInput) {
            desc = IDE.getEditorDescriptor((IFile)((IFileEditorInput)input).getFile());
        } else {
            URI uri = null;
            if (input instanceof IURIEditorInput) {
                uri = URI.createURI((String)((IURIEditorInput)input).getURI().toString(), (boolean)true);
            } else if (input instanceof URIEditorInput) {
                uri = ((URIEditorInput)input).getURI();
            }
            desc = uri != null ? IDE.getEditorDescriptor((String)uri.lastSegment()) : IDE.getEditorDescriptor((String)input.getName());
        }
        return desc == null ? "org.eclipse.papyrus.infra.core.papyrusEditor" : desc.getId();
    }

    protected void initDiagramModel(ModelSet modelSet, String contextId) {
        this.initDiagrams(modelSet, contextId);
    }

    private void saveDiagram(ModelSet modelSet) {
        try {
            modelSet.save((IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected void initDiagrams(ModelSet modelSet, String contextId) {
        this.initDiagrams(modelSet, null, contextId);
    }

    protected void initDiagrams(ModelSet resourceSet, EObject root, String contextId) {
        UmlModel model = (UmlModel)resourceSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
        EList roots = model.getResource().getContents();
        if (!roots.isEmpty() && (root = (EObject)roots.get(0)) instanceof NamedElement) {
            this.getCommandStack(resourceSet).execute((Command)new RenameElementCommand(resourceSet.getTransactionalEditingDomain(), (NamedElement)root, this.getRootElementName()));
        }
        List<RepresentationKind> creationCommands = this.getRepresentationKindsFor(contextId);
        List<String> diagramName = this.selectRepresentationKindPage.getDiagramName();
        if (creationCommands.isEmpty()) {
            this.createEmptyDiagramEditor(resourceSet);
        } else {
            int i = 0;
            while (i < creationCommands.size()) {
                RepresentationKind kind = creationCommands.get(i);
                if (kind instanceof PapyrusRepresentationKind) {
                    ViewPrototype proto = ViewPrototype.get((PapyrusRepresentationKind)((PapyrusRepresentationKind)kind));
                    proto.instantiateOn(root, diagramName.get(i));
                }
                ++i;
            }
        }
    }

    protected List<RepresentationKind> getRepresentationKindsFor(String contextId) {
        return this.selectRepresentationKindPage.getSelectedRepresentationKinds(contextId);
    }

    protected List<String> getDiagramNames() {
        return this.selectRepresentationKindPage.getDiagramName();
    }

    protected String getRootElementName() {
        return this.selectRepresentationKindPage.getRootElementName();
    }

    private void createEmptyDiagramEditor(ModelSet modelSet) {
        EditorUtils.getIPageMngr((Resource)SashModelUtils.getSashModel((ModelSet)modelSet).getResource());
    }

    protected final CommandStack getCommandStack(ModelSet modelSet) {
        return modelSet.getTransactionalEditingDomain().getCommandStack();
    }

    public IStatus architectureContextChanged(String ... newContexts) {
        return this.getSelectedStorageProvider().validateArchitectureContexts(newContexts);
    }

    protected void initStorageProvider(IWorkbench workbench, IStructuredSelection selection) {
        NewModelStorageProviderRegistry registry = new NewModelStorageProviderRegistry((IEvaluationService)workbench.getService(IEvaluationService.class));
        if (this.isCreateProjectWizard()) {
            this.selectedStorageProvider = new WorkspaceNewModelStorageProvider();
        } else {
            INewModelStorageProvider firstProvider = null;
            for (INewModelStorageProvider next : registry) {
                if (firstProvider == null) {
                    firstProvider = next;
                }
                if (selection.isEmpty() || !next.canHandle(selection)) continue;
                this.selectedStorageProvider = next;
                break;
            }
            if (this.selectedStorageProvider == null) {
                this.selectedStorageProvider = firstProvider;
                if (registry.size() > 1) {
                    this.storageProviderRegistry = registry;
                }
            }
        }
    }

    protected SelectStorageProviderPage createSelectStorageProviderPage() {
        SelectStorageProviderPage result;
        SelectStorageProviderPage selectStorageProviderPage = result = this.storageProviderRegistry == null ? null : new SelectStorageProviderPage(this.storageProviderRegistry);
        if (result != null) {
            result.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    INewModelStorageProvider provider = (INewModelStorageProvider)((IStructuredSelection)event.getSelection()).getFirstElement();
                    CreateModelWizard.this.setSelectedStorageProvider(provider);
                }
            });
        }
        return result;
    }

    protected Iterable<? extends INewModelStorageProvider> getStorageProviders() {
        Iterable<NewModelStorageProviderRegistry.Descriptor> result = this.storageProviderRegistry != null ? this.storageProviderRegistry : (this.selectedStorageProvider != null ? Collections.singletonList(this.selectedStorageProvider) : Collections.emptyList());
        return result;
    }

    protected INewModelStorageProvider getSelectedStorageProvider() {
        return this.selectedStorageProvider;
    }

    private void setSelectedStorageProvider(INewModelStorageProvider provider) {
        this.selectedStorageProvider = provider;
        this.getContainer().updateButtons();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        List<IWizardPage> allPages = Arrays.asList(this.getPages());
        IWizardPage result = null;
        INewModelStorageProvider provider = this.providersByPage.get(page);
        if (provider != null) {
            List<IWizardPage> pages = this.providerPages.get(provider);
            int index = pages.indexOf(page);
            if (index >= 0 && index < pages.size() - 1) {
                result = pages.get(index + 1);
            } else if (this.endProviderPageIndex < allPages.size()) {
                result = allPages.get(this.endProviderPageIndex);
            }
        } else if (allPages.indexOf(page) == this.startProviderPageIndex) {
            List<IWizardPage> pages = this.providerPages.get(this.getSelectedStorageProvider());
            if (!pages.isEmpty()) {
                result = pages.get(0);
            } else if (this.endProviderPageIndex < allPages.size()) {
                result = allPages.get(this.endProviderPageIndex);
            }
        } else {
            result = super.getNextPage(page);
        }
        return result;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        List<IWizardPage> allPages = Arrays.asList(this.getPages());
        IWizardPage result = null;
        INewModelStorageProvider provider = this.providersByPage.get(page);
        if (provider != null) {
            List<IWizardPage> pages = this.providerPages.get(provider);
            int index = pages.indexOf(page);
            if (index > 0) {
                result = pages.get(index - 1);
            } else if (this.startProviderPageIndex > 0) {
                result = allPages.get(this.startProviderPageIndex - 1);
            }
        } else if (allPages.indexOf(page) == this.endProviderPageIndex) {
            List<IWizardPage> pages = this.providerPages.get(this.getSelectedStorageProvider());
            if (!pages.isEmpty()) {
                result = pages.get(pages.size() - 1);
            } else if (this.startProviderPageIndex >= 0) {
                result = allPages.get(this.startProviderPageIndex);
            }
        } else {
            result = super.getPreviousPage(page);
        }
        return result;
    }

    public boolean canFinish() {
        INewPapyrusModelPage page;
        boolean result = true;
        IWizardPage[] allPages = this.getPages();
        int i = 0;
        while (result && i <= this.startProviderPageIndex) {
            result = allPages[i].isPageComplete();
            ++i;
        }
        if (result) {
            for (IWizardPage next : this.providerPages.get(this.selectedStorageProvider)) {
                if (next.isPageComplete()) continue;
                result = false;
                break;
            }
        }
        i = this.endProviderPageIndex;
        while (result && i < allPages.length) {
            result = allPages[i].isPageComplete();
            ++i;
        }
        if (result && (page = this.getNewModelPage()) != null) {
            result = page.canFlipToNextPage();
        }
        return result;
    }

    private INewPapyrusModelPage getNewModelPage() {
        return this.getPage(INewPapyrusModelPage.class);
    }

    protected <P extends IWizardPage> P getPage(Class<P> type) {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage next = iWizardPageArray[n2];
            if (type.isInstance(next)) {
                return (P)((IWizardPage)type.cast(next));
            }
            ++n2;
        }
        return null;
    }

    public String getModelKindName() {
        return "Papyrus";
    }

    @Deprecated
    protected void saveDiagramCategorySettings() {
    }

    public boolean isPapyrusRootWizard() {
        return true;
    }
}

