/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.node.internal.launch.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.WorkingDirectoryBlock;
import org.eclipse.wst.jsdt.js.node.NodePlugin;

public class NodeWorkingDirectoryBlock
extends WorkingDirectoryBlock {
    public NodeWorkingDirectoryBlock(String workingDirectoryAttribteName) {
        super(workingDirectoryAttribteName);
    }

    protected IProject getProject(ILaunchConfiguration launchConfiguration) throws CoreException {
        IProject project;
        IStatus status;
        String projectName = "";
        try {
            projectName = launchConfiguration.getAttribute("attr_app_project", "");
        }
        catch (CoreException e) {
            NodePlugin.logError(e, e.getLocalizedMessage());
        }
        if (!projectName.equals("") && (status = ResourcesPlugin.getWorkspace().validateName(projectName, 4)).isOK() && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null && project.isAccessible()) {
            return project;
        }
        return null;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setLaunchConfiguration(configuration);
        try {
            String wd = configuration.getAttribute("attr_working_directory", "");
            this.setDefaultWorkingDir();
            if (!wd.equals("")) {
                this.setOtherWorkingDirectoryText(wd);
            }
        }
        catch (CoreException e) {
            NodePlugin.logError(e, e.getLocalizedMessage());
        }
    }
}

