/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage;

import com.google.common.base.Joiner;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.CpuUsageDataProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.Messages;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectedCpuQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfXYDataProvider;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXLineChartViewer;

public class CpuUsageXYViewer
extends TmfCommonXLineChartViewer {
    private static final @NonNull String NOT_SELECTED = "-1";
    private final @NonNull Set<@NonNull Integer> fCpus = new TreeSet<Integer>();
    private static final double RESOLUTION = 0.4;
    private @NonNull String fSelectedThread = "-1";

    public CpuUsageXYViewer(Composite parent) {
        super(parent, Messages.CpuUsageXYViewer_Title, Messages.CpuUsageXYViewer_TimeXAxis, Messages.CpuUsageXYViewer_CpuYAxis);
        this.setResolution(0.4);
        this.getSwtChart().getTitle().setVisible(true);
        this.getSwtChart().getLegend().setVisible(false);
    }

    protected void initializeDataSource() {
        ITmfTrace trace = this.getTrace();
        this.setDataProvider((ITmfXYDataProvider)CpuUsageDataProvider.create((ITmfTrace)trace));
    }

    protected TimeQueryFilter createQueryFilter(long start, long end, int nb) {
        return new SelectedCpuQueryFilter(start, end, nb, this.fSelectedThread, this.fCpus);
    }

    protected String getSeriesType(String seriesName) {
        if (seriesName.equals(Messages.CpuUsageXYViewer_Total)) {
            return "line";
        }
        return "area";
    }

    public void setSelectedThread(@NonNull String tid) {
        this.cancelUpdate();
        this.deleteSeries(this.fSelectedThread);
        this.fSelectedThread = tid;
        this.updateContent();
    }

    public void addCpu(int core) {
        this.fCpus.add(core);
        this.cancelUpdate();
        this.updateContent();
        this.getSwtChart().getTitle().setText(String.valueOf(Messages.CpuUsageView_Title) + ' ' + this.getCpuList());
    }

    public void removeCpu(int core) {
        this.fCpus.remove(core);
        this.cancelUpdate();
        this.updateContent();
        this.getSwtChart().getTitle().setText(String.valueOf(Messages.CpuUsageView_Title) + ' ' + this.getCpuList());
    }

    private String getCpuList() {
        return Joiner.on((String)", ").join(this.fCpus);
    }

    public void clearCpu() {
        this.fCpus.clear();
        this.cancelUpdate();
        this.updateContent();
        this.getSwtChart().getTitle().setText(Messages.CpuUsageView_Title);
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        this.initSelection();
        this.initCPU();
        super.traceSelected(signal);
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        this.initSelection();
        this.initCPU();
        super.traceOpened(signal);
    }

    private void initSelection() {
        TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
        String data = (String)ctx.getData("org.eclipse.tracecompass.analysis.os.linux.views.cpuusage.CPU_USAGE_SELECTED_TRHEAD");
        String thread = data != null ? data : NOT_SELECTED;
        this.setSelectedThread(thread);
    }

    private void initCPU() {
        this.clearCpu();
        TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
        Object data = ctx.getData("org.eclipse.tracecompass.analysis.os.linux.views.cpuusage.FOLLOW_CPU");
        if (data instanceof Set) {
            Set set = (Set)data;
            for (Object coreObject : set) {
                Integer core = (Integer)coreObject;
                if (core == null || core < 0) continue;
                this.addCpu(core);
            }
        }
    }
}

