/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.Predicate;
import org.eclipse.tracecompass.internal.analysis.lami.core.Activator;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.ShellUtils;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiAnalysis;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiAnalysisFactoryException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public final class LamiAnalysisFactoryFromConfigFile {
    private LamiAnalysisFactoryFromConfigFile() {
    }

    private static String getProperty(Properties props, String propName) throws LamiAnalysisFactoryException {
        String prop = props.getProperty(propName);
        if (prop == null) {
            throw new LamiAnalysisFactoryException(String.format("Cannot find \"%s\" property", propName));
        }
        if ((prop = prop.trim()).isEmpty()) {
            throw new LamiAnalysisFactoryException(String.format("\"%s\" property cannot be empty", propName));
        }
        return prop;
    }

    public static LamiAnalysis buildFromInputStream(InputStream inputStream, boolean isUserDefined, Predicate<ITmfTrace> appliesTo) throws LamiAnalysisFactoryException {
        Properties props = new Properties();
        try {
            props.load(inputStream);
        }
        catch (IOException e) {
            throw new LamiAnalysisFactoryException(e);
        }
        String name = LamiAnalysisFactoryFromConfigFile.getProperty(props, "name");
        String command = LamiAnalysisFactoryFromConfigFile.getProperty(props, "command");
        List<String> args = ShellUtils.commandStringToArgs(command);
        return new LamiAnalysis(name, isUserDefined, appliesTo, args);
    }

    public static LamiAnalysis buildFromConfigFile(Path configFilePath, boolean isUserDefined, Predicate<ITmfTrace> appliesTo) throws LamiAnalysisFactoryException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream propsStream = new FileInputStream(configFilePath.toFile());){
                return LamiAnalysisFactoryFromConfigFile.buildFromInputStream(propsStream, isUserDefined, appliesTo);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new LamiAnalysisFactoryException(e);
        }
    }

    public static List<LamiAnalysis> buildFromConfigDir(Path configDir, boolean isUserDefined, Predicate<ITmfTrace> appliesTo) throws LamiAnalysisFactoryException {
        ArrayList<LamiAnalysis> analyses = new ArrayList<LamiAnalysis>();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(configDir);){
                for (Path path : directoryStream) {
                    try {
                        analyses.add(LamiAnalysisFactoryFromConfigFile.buildFromConfigFile(path, isUserDefined, appliesTo));
                    }
                    catch (LamiAnalysisFactoryException e) {
                        Activator.instance().logWarning(String.format("Cannot load external analysis \"%s\"", path));
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new LamiAnalysisFactoryException(e);
        }
        return analyses;
    }
}

