/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.m2e;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.scm.MavenProjectScmInfo;
import org.eclipse.m2e.scm.spi.ScmHandler;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.file.CheckoutAsOperation;
import org.eclipse.team.svn.core.operation.remote.GetFileContentOperation;
import org.eclipse.team.svn.core.operation.remote.management.AddRepositoryLocationOperation;
import org.eclipse.team.svn.core.operation.remote.management.SaveRepositoryLocationsOperation;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.ILoggedOperationFactory;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class SVNScmHandler
extends ScmHandler {
    public static final String SVN_SCM_ID = "scm:svn:";

    public InputStream open(String url, String revision) throws CoreException {
        IRepositoryContainer container = this.getRepositoryContainer(url, revision);
        GetFileContentOperation op = new GetFileContentOperation((IRepositoryResource)container.asRepositoryFile(String.valueOf(url) + "/" + "pom.xml", false));
        this.runOperation((IActionOperation)op, null);
        return op.getContent();
    }

    public void checkoutProject(MavenProjectScmInfo projectInfo, File destination, IProgressMonitor monitor) throws CoreException, InterruptedException {
        IRepositoryContainer container = this.getRepositoryContainer(projectInfo.getFolderUrl(), projectInfo.getRevision());
        CheckoutAsOperation op = new CheckoutAsOperation(destination, (IRepositoryResource)container, SVNDepth.INFINITY, false, true);
        String locationId = container.getRepositoryLocation().getId();
        if (SVNRemoteStorage.instance().getRepositoryLocation(locationId) == null) {
            CompositeOperation cOp = new CompositeOperation(op.getOperationName(), op.getMessagesClass());
            cOp.add((IActionOperation)op);
            AddRepositoryLocationOperation add = new AddRepositoryLocationOperation(container.getRepositoryLocation());
            cOp.add((IActionOperation)add, new IActionOperation[]{op});
            cOp.add((IActionOperation)new SaveRepositoryLocationsOperation(), new IActionOperation[]{add});
            op = cOp;
        }
        this.runOperation((IActionOperation)op, monitor);
    }

    protected void runOperation(IActionOperation op, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtility.doTaskExternal((IActionOperation)op, (IProgressMonitor)monitor, (ILoggedOperationFactory)ILoggedOperationFactory.EMPTY);
        if (op.getExecutionState() != 0) {
            throw new CoreException(op.getStatus());
        }
    }

    protected IRepositoryContainer getRepositoryContainer(String url, String revision) throws CoreException {
        url = url.substring(SVN_SCM_ID.length());
        try {
            SVNUtility.getSVNUrl((String)url);
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, ((Object)((Object)this)).getClass().getName(), 0, "Invalid url " + url, (Throwable)e));
        }
        IRepositoryContainer retVal = (IRepositoryContainer)SVNUtility.asRepositoryResource((String)url, (boolean)true);
        retVal.setSelectedRevision(SVNRevision.fromString((String)revision));
        return retVal;
    }
}

